/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.output;

import com.lambdaworks.redis.LettuceStrings;
import com.lambdaworks.redis.ScoredValue;
import com.lambdaworks.redis.StreamScanCursor;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.output.ScanOutput;
import com.lambdaworks.redis.output.ScoredValueStreamingChannel;
import java.nio.ByteBuffer;

public class ScoredValueScanStreamingOutput<K, V>
extends ScanOutput<K, V, StreamScanCursor> {
    private final ScoredValueStreamingChannel<V> channel;
    private V value;

    public ScoredValueScanStreamingOutput(RedisCodec<K, V> codec, ScoredValueStreamingChannel<V> channel) {
        super(codec, new StreamScanCursor());
        this.channel = channel;
    }

    @Override
    protected void setOutput(ByteBuffer bytes) {
        if (this.value == null) {
            this.value = this.codec.decodeValue(bytes);
            return;
        }
        double score = LettuceStrings.toDouble(this.decodeAscii(bytes));
        this.channel.onValue(new ScoredValue<V>(score, this.value));
        this.value = null;
        ((StreamScanCursor)this.output).setCount(((StreamScanCursor)this.output).getCount() + 1L);
    }
}

