/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.beanstalk;

import br.com.ingenieux.mojo.aws.AbstractAWSMojo;
import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient;
import com.amazonaws.services.elasticbeanstalk.model.ApplicationDescription;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsResult;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentDescription;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;

public abstract class AbstractBeanstalkMojo
extends AbstractAWSMojo<AWSElasticBeanstalkClient> {
    protected List<ConfigurationOptionSetting> getOptionSettings(ConfigurationOptionSetting[] optionSettings) {
        ConfigurationOptionSetting[] arrOptionSettings = optionSettings;
        if (null == arrOptionSettings || 0 == arrOptionSettings.length) {
            return Collections.emptyList();
        }
        return Arrays.asList(arrOptionSettings);
    }

    protected EnvironmentDescription lookupEnvironment(String applicationName, String environmentCNamePrefix, String environmentName) throws MojoExecutionException {
        if (StringUtils.isBlank((String)environmentCNamePrefix) && StringUtils.isBlank((String)environmentName)) {
            throw new MojoExecutionException("You must declare either cnamePrefix or environmentName");
        }
        DescribeEnvironmentsRequest req = new DescribeEnvironmentsRequest().withApplicationName(applicationName);
        DescribeEnvironmentsResult result = null;
        result = ((AWSElasticBeanstalkClient)this.getService()).describeEnvironments(req);
        ArrayList<EnvironmentDescription> environments = new ArrayList<EnvironmentDescription>();
        boolean bLookupEnvironmentName = StringUtils.isNotBlank((String)environmentName);
        boolean bLookupCnamePrefix = !bLookupEnvironmentName;
        String cNameToFind = null;
        if (bLookupCnamePrefix) {
            cNameToFind = String.format("%s.elasticbeanstalk.com", environmentCNamePrefix);
            this.getLog().info((CharSequence)("Looking up for " + cNameToFind));
        }
        for (EnvironmentDescription d : result.getEnvironments()) {
            if (d.getStatus().startsWith("Termin")) continue;
            boolean bFound = false;
            bFound = bLookupEnvironmentName ? environmentName.equals(d.getEnvironmentName()) : cNameToFind.equals(d.getCNAME());
            if (!bFound) continue;
            environments.add(d);
        }
        return this.handleResults(environments);
    }

    protected EnvironmentDescription handleResults(List<EnvironmentDescription> environments) throws MojoExecutionException {
        int len = environments.size();
        if (1 == len) {
            return environments.get(0);
        }
        this.handleNonSingle(len);
        return null;
    }

    protected void handleNonSingle(int len) throws MojoExecutionException {
        if (0 == len) {
            throw new MojoExecutionException("No environments found");
        }
        throw new MojoExecutionException("Multiple environments found matching the supplied parameters (may you file a bug report?)");
    }

    protected boolean harmfulOptionSettingP(String environmentId, ConfigurationOptionSetting optionSetting) {
        boolean bInvalid = StringUtils.isBlank((String)optionSetting.getValue());
        if (!bInvalid) {
            boolean bl = bInvalid = optionSetting.getNamespace().equals("aws:cloudformation:template:parameter") && optionSetting.getOptionName().equals("AppSource");
        }
        if (!bInvalid) {
            boolean bl = bInvalid = optionSetting.getNamespace().equals("aws:elasticbeanstalk:sns:topics") && optionSetting.getOptionName().equals("Notification Topic ARN");
        }
        if (!bInvalid && StringUtils.isNotBlank((String)environmentId)) {
            bInvalid = optionSetting.getValue().contains(environmentId);
        }
        return bInvalid;
    }

    public String lookupTemplateName(String applicationName, String templateName) {
        if (!this.hasWildcards(StringUtils.defaultString((String)templateName))) {
            return templateName;
        }
        this.getLog().info((CharSequence)String.format("Template Name %s contains wildcards. A Lookup is needed", templateName));
        List<String> configurationTemplates = this.getConfigurationTemplates(applicationName);
        for (String configTemplateName : configurationTemplates) {
            this.getLog().debug((CharSequence)String.format(" * Found Template Name: %s", configTemplateName));
        }
        Pattern templateMask = Pattern.compile(templateName.replaceAll("\\.", "\\\\.").replaceAll("\\Q*\\E", ".*").replaceAll("\\Q?\\E", "."));
        for (String s : configurationTemplates) {
            Matcher m = templateMask.matcher(s);
            if (!m.matches()) continue;
            this.getLog().info((CharSequence)String.format("Selecting: %s", s));
            return s;
        }
        this.getLog().info((CharSequence)"Not found");
        return null;
    }

    public boolean hasWildcards(String input) {
        return input.indexOf(42) != -1 || input.indexOf(63) != -1;
    }

    private List<String> getConfigurationTemplates(String applicationName) {
        List configurationTemplates = ((ApplicationDescription)((AWSElasticBeanstalkClient)this.getService()).describeApplications(new DescribeApplicationsRequest().withApplicationNames(new String[]{applicationName})).getApplications().get(0)).getConfigurationTemplates();
        Collections.sort(configurationTemplates, new ReverseComparator(String.CASE_INSENSITIVE_ORDER));
        return configurationTemplates;
    }
}

