/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.beanstalk.bundle;

import br.com.ingenieux.mojo.aws.util.BeanstalkerS3Client;
import br.com.ingenieux.mojo.beanstalk.AbstractBeanstalkMojo;
import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="upload-source-bundle")
public class UploadSourceBundleMojo
extends AbstractBeanstalkMojo {
    @Parameter(property="beanstalk.s3Bucket", defaultValue="${project.artifactId}", required=true)
    String s3Bucket;
    @Parameter(property="beanstalk.s3Key", defaultValue="${project.build.finalName}.${project.packaging}", required=true)
    String s3Key;
    @Parameter(property="beanstalk.s3Region")
    String s3Region;
    @Parameter(property="beanstalk.multipartUpload", defaultValue="true")
    boolean multipartUpload = true;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}.${project.packaging}")
    File artifactFile;

    protected Object executeInternal() throws MojoExecutionException, MojoFailureException, AmazonServiceException, AmazonClientException, InterruptedException {
        String path = this.artifactFile.getPath();
        if (!path.endsWith(".war") && !path.endsWith(".jar")) {
            this.getLog().warn((CharSequence)"Not a war/jar file. Skipping");
            return null;
        }
        if (!this.artifactFile.exists()) {
            throw new MojoFailureException("Artifact File does not exists! (file=" + path);
        }
        BeanstalkerS3Client client = new BeanstalkerS3Client(this.getAWSCredentials(), this.getClientConfiguration());
        client.setMultipartUpload(this.multipartUpload);
        if (StringUtils.isNotBlank((String)this.s3Region)) {
            client.setEndpoint(String.format("s3-%s.amazonaws.com", this.s3Region));
        }
        this.getLog().info((CharSequence)("Target Path: s3://" + this.s3Bucket + "/" + this.s3Key));
        this.getLog().info((CharSequence)("Uploading artifact file: " + path));
        PutObjectResult result = client.putObject(new PutObjectRequest(this.s3Bucket, this.s3Key, this.artifactFile));
        this.getLog().info((CharSequence)"Artifact Uploaded");
        return result;
    }
}

