/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.beanstalk.cmd.env.waitfor;

import br.com.ingenieux.mojo.beanstalk.AbstractBeanstalkMojo;
import br.com.ingenieux.mojo.beanstalk.cmd.BaseCommand;
import br.com.ingenieux.mojo.beanstalk.cmd.env.waitfor.WaitForEnvironmentContext;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsResult;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentDescription;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.maven.plugin.AbstractMojoExecutionException;
import org.apache.maven.plugin.MojoExecutionException;

public class WaitForEnvironmentCommand
extends BaseCommand<WaitForEnvironmentContext, EnvironmentDescription> {
    public static final long POLL_INTERVAL = 90000L;
    private static final long MINS_TO_MSEC = 60000L;

    public WaitForEnvironmentCommand(AbstractBeanstalkMojo parentMojo) throws AbstractMojoExecutionException {
        super(parentMojo);
    }

    @Override
    public EnvironmentDescription executeInternal(WaitForEnvironmentContext context) throws Exception {
        long timeoutMins = context.getTimeoutMins().intValue();
        String environmentId = context.getEnvironmentId();
        String applicationName = context.getApplicationName();
        String statusToWaitFor = context.getStatusToWaitFor();
        boolean hasDomainToWaitFor = StringUtils.isNotBlank((String)context.getDomainToWaitFor());
        String domainToWaitFor = String.format("%s.elasticbeanstalk.com", context.getDomainToWaitFor());
        Date expiresAt = new Date(System.currentTimeMillis() + 60000L * timeoutMins);
        boolean done = false;
        this.info("Will wait until " + expiresAt + " for environment " + environmentId + " to get into " + statusToWaitFor);
        if (hasDomainToWaitFor) {
            this.info("... as well as having domain " + domainToWaitFor);
        }
        while (true) {
            if (this.timedOutP(expiresAt)) {
                throw new MojoExecutionException("Timed out");
            }
            DescribeEnvironmentsRequest req = new DescribeEnvironmentsRequest().withApplicationName(applicationName).withEnvironmentIds(new String[]{environmentId});
            if (statusToWaitFor.startsWith("Terminat")) {
                req.withIncludeDeleted(Boolean.valueOf(true));
            }
            DescribeEnvironmentsResult result = this.service.describeEnvironments(req);
            boolean covered = false;
            for (EnvironmentDescription d : result.getEnvironments()) {
                this.debug("Environment Detail:" + ToStringBuilder.reflectionToString((Object)d));
                done = d.getStatus().equalsIgnoreCase(statusToWaitFor);
                covered |= d.getEnvironmentId().equals(environmentId);
                if (done && hasDomainToWaitFor) {
                    done = domainToWaitFor.equals(d.getCNAME());
                }
                if (!done) continue;
                return d;
            }
            if (!covered && "Terminated".equals(statusToWaitFor)) {
                this.info(String.format("Environment id %s not even returned. Probably gone", environmentId));
                return null;
            }
            this.sleepInterval(90000L);
        }
    }

    boolean timedOutP(Date expiresAt) throws MojoExecutionException {
        return expiresAt.before(new Date(System.currentTimeMillis()));
    }

    public void sleepInterval(long pollInterval) {
        this.logger.info((CharSequence)String.format("Sleeping for %d seconds", pollInterval / 1000L));
        try {
            Thread.sleep(pollInterval);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

