/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.beanstalk.dns;

import br.com.ingenieux.mojo.beanstalk.AbstractNeedsEnvironmentMojo;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest;
import com.amazonaws.services.elasticbeanstalk.model.LoadBalancer;
import com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancing;
import com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersRequest;
import com.amazonaws.services.elasticloadbalancing.model.LoadBalancerDescription;
import com.amazonaws.services.route53.AmazonRoute53;
import com.amazonaws.services.route53.AmazonRoute53Client;
import com.amazonaws.services.route53.model.AliasTarget;
import com.amazonaws.services.route53.model.Change;
import com.amazonaws.services.route53.model.ChangeAction;
import com.amazonaws.services.route53.model.ChangeBatch;
import com.amazonaws.services.route53.model.ChangeResourceRecordSetsRequest;
import com.amazonaws.services.route53.model.HostedZone;
import com.amazonaws.services.route53.model.ListResourceRecordSetsRequest;
import com.amazonaws.services.route53.model.ListResourceRecordSetsResult;
import com.amazonaws.services.route53.model.RRType;
import com.amazonaws.services.route53.model.ResourceRecordSet;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="bind-domains")
public class BindDomainsMojo
extends AbstractNeedsEnvironmentMojo {
    @Parameter(property="beanstalk.domains")
    String[] domains;

    protected Object executeInternal() throws Exception {
        LinkedHashMap<String, String> recordsToAssign = new LinkedHashMap<String, String>();
        BindDomainContext ctx = new BindDomainContext();
        for (String domain : this.domains) {
            String key = this.formatDomain(domain);
            String value = null;
            if (-1 != key.indexOf(58)) {
                String[] pair = key.split(":", 2);
                key = this.formatDomain(pair[0]);
                value = StringUtils.strip((String)pair[1], (String)".");
            }
            recordsToAssign.put(key, value);
        }
        Validate.isTrue((recordsToAssign.size() > 0 ? 1 : 0) != 0, (String)"No Domains Supplied!");
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)String.format("Domains to Map to Environment (cnamePrefix='%s')", this.curEnv.getCNAME()));
            for (Map.Entry entry : recordsToAssign.entrySet()) {
                String key = (String)entry.getKey();
                String zoneId = (String)entry.getValue();
                String message = String.format(" * Domain: %s", key);
                if (null != zoneId) {
                    message = message + " (and using zoneId " + zoneId + ")";
                }
                this.getLog().info((CharSequence)message);
            }
        }
        LinkedHashMap<String, HostedZone> hostedZoneMapping = new LinkedHashMap<String, HostedZone>();
        LinkedHashSet unresolvedDomains = new LinkedHashSet();
        for (Map.Entry entry : recordsToAssign.entrySet()) {
            if (null != entry.getValue()) continue;
            unresolvedDomains.add(entry.getKey());
        }
        for (HostedZone hostedZone : ctx.r53.listHostedZones().getHostedZones()) {
            String id = hostedZone.getId();
            String name = hostedZone.getName();
            hostedZoneMapping.put(id, hostedZone);
            if (!unresolvedDomains.contains(name)) continue;
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)String.format("Mapping Domain %s to R53 Zone Id %s", name, id));
            }
            recordsToAssign.put(name, id);
            unresolvedDomains.remove(name);
        }
        Validate.isTrue((boolean)unresolvedDomains.isEmpty(), (String)("Domains not resolved: " + StringUtils.join(unresolvedDomains, (String)"; ")));
        for (Map.Entry entry : recordsToAssign.entrySet()) {
            String record = (String)entry.getKey();
            String zoneId = (String)entry.getValue();
            HostedZone hostedZone = (HostedZone)hostedZoneMapping.get(zoneId);
            Validate.notNull((Object)hostedZone, (String)String.format("Unknown Hosted Zone Id: %s for Record: %s", zoneId, record));
            Validate.isTrue((boolean)record.endsWith(hostedZone.getName()), (String)String.format("Record %s does not map to zoneId %s (domain: %s)", record, zoneId, hostedZone.getName()));
        }
        String loadBalancerName = ((LoadBalancer)((AWSElasticBeanstalkClient)this.getService()).describeEnvironmentResources(new DescribeEnvironmentResourcesRequest().withEnvironmentId(this.curEnv.getEnvironmentId())).getEnvironmentResources().getLoadBalancers().get(0)).getName();
        DescribeLoadBalancersRequest req = new DescribeLoadBalancersRequest(Arrays.asList(loadBalancerName));
        List loadBalancers = ctx.elb.describeLoadBalancers(req).getLoadBalancerDescriptions();
        Validate.isTrue((1 == loadBalancers.size() ? 1 : 0) != 0, (String)"Unexpected number of Load Balancers returned");
        ctx.elbHostedZoneId = ((LoadBalancerDescription)loadBalancers.get(0)).getCanonicalHostedZoneNameID();
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)String.format("Using ELB Canonical Hosted Zone Name Id %s", ctx.elbHostedZoneId));
        }
        for (Map.Entry recordEntry : recordsToAssign.entrySet()) {
            this.assignDomain(ctx, (String)recordEntry.getKey(), (String)recordEntry.getValue());
        }
        return null;
    }

    protected void assignDomain(BindDomainContext ctx, String record, String zoneId) {
        ChangeBatch changeBatch = new ChangeBatch();
        ResourceRecordSet resourceRecordSet = null;
        ListResourceRecordSetsResult listResourceRecordSets = ctx.r53.listResourceRecordSets(new ListResourceRecordSetsRequest(zoneId));
        for (ResourceRecordSet rrs : listResourceRecordSets.getResourceRecordSets()) {
            if (!rrs.getName().equals(record) || !"A".equals(rrs.getType())) continue;
            resourceRecordSet = rrs;
            break;
        }
        if (null != resourceRecordSet) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)String.format("Excluding resourceRecordSet %s for domain %s", resourceRecordSet, record));
            }
            changeBatch.getChanges().add(new Change(ChangeAction.DELETE, resourceRecordSet));
        }
        AliasTarget aliasTarget = new AliasTarget();
        aliasTarget.setHostedZoneId(ctx.elbHostedZoneId);
        aliasTarget.setDNSName(this.curEnv.getEndpointURL());
        ResourceRecordSet resourceRecordSet2 = new ResourceRecordSet();
        resourceRecordSet2.setName(record);
        resourceRecordSet2.setType(RRType.A);
        resourceRecordSet2.setAliasTarget(aliasTarget);
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)String.format("Adding resourceRecordSet %s for domain %s mapped to %s", resourceRecordSet2, record, aliasTarget.getDNSName()));
        }
        changeBatch.getChanges().add(new Change(ChangeAction.CREATE, resourceRecordSet2));
        ChangeResourceRecordSetsRequest req = new ChangeResourceRecordSetsRequest(zoneId, changeBatch);
        ctx.r53.changeResourceRecordSets(req);
    }

    String formatDomain(String d) {
        return StringUtils.strip((String)d, (String)".").concat(".");
    }

    class BindDomainContext {
        String elbHostedZoneId;
        AmazonRoute53 r53;
        AmazonEC2 ec2;
        AmazonElasticLoadBalancing elb;

        public BindDomainContext() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
            this.r53 = (AmazonRoute53)BindDomainsMojo.this.clientFactory.getService(AmazonRoute53Client.class);
            this.ec2 = (AmazonEC2)BindDomainsMojo.this.clientFactory.getService(AmazonEC2Client.class);
            this.elb = (AmazonElasticLoadBalancing)BindDomainsMojo.this.clientFactory.getService(AmazonElasticLoadBalancingClient.class);
        }

        public void setElbHostedZoneId(String elbHostedZoneId) {
            this.elbHostedZoneId = elbHostedZoneId;
        }

        public String getElbHostedZoneId() {
            return this.elbHostedZoneId;
        }
    }
}

