/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.beanstalk;

import br.com.ingenieux.mojo.aws.AbstractAWSMojo;
import br.com.ingenieux.mojo.beanstalk.cmd.env.waitfor.WaitForEnvironmentCommand;
import br.com.ingenieux.mojo.beanstalk.cmd.env.waitfor.WaitForEnvironmentContext;
import br.com.ingenieux.mojo.beanstalk.cmd.env.waitfor.WaitForEnvironmentContextBuilder;
import br.com.ingenieux.mojo.beanstalk.util.ConfigUtil;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsResult;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient;
import com.amazonaws.services.elasticbeanstalk.model.ApplicationDescription;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsRequest;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentDescription;
import com.amazonaws.services.elasticbeanstalk.model.SolutionStackDescription;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractBeanstalkMojo
extends AbstractAWSMojo<AWSElasticBeanstalkClient> {
    @Parameter(property="beanstalk.endpointUrl")
    protected String endpointUrl;

    protected List<ConfigurationOptionSetting> getOptionSettings(ConfigurationOptionSetting[] optionSettings) {
        ConfigurationOptionSetting[] arrOptionSettings = optionSettings;
        if (null == arrOptionSettings || 0 == arrOptionSettings.length) {
            return Collections.emptyList();
        }
        return Arrays.asList(arrOptionSettings);
    }

    protected EnvironmentDescription lookupEnvironment(String applicationName, String environmentRef) throws MojoExecutionException {
        WaitForEnvironmentContext ctx = ((WaitForEnvironmentContextBuilder)((WaitForEnvironmentContextBuilder)new WaitForEnvironmentContextBuilder().withApplicationName(applicationName)).withEnvironmentRef(environmentRef)).build();
        Collection<EnvironmentDescription> environments = new WaitForEnvironmentCommand(this).lookupInternal(ctx);
        return this.handleResults(environments);
    }

    protected EnvironmentDescription handleResults(Collection<EnvironmentDescription> environments) throws MojoExecutionException {
        int len = environments.size();
        if (1 == len) {
            return environments.iterator().next();
        }
        this.handleNonSingle(len);
        return null;
    }

    protected void handleNonSingle(int len) throws MojoExecutionException {
        if (0 == len) {
            throw new MojoExecutionException("No environments found");
        }
        throw new MojoExecutionException("Multiple environments found matching the supplied parameters (may you file a bug report?)");
    }

    protected boolean harmfulOptionSettingP(final String environmentId, ConfigurationOptionSetting optionSetting) throws Exception {
        boolean bInvalid;
        if (ConfigUtil.optionSettingMatchesP(optionSetting, "aws:autoscaling:launchconfiguration", "SecurityGroups")) {
            String securityGroup = optionSetting.getValue();
            if (-1 != securityGroup.indexOf(environmentId)) {
                return true;
            }
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("Probing security group '" + securityGroup + "'"));
            }
            Validate.isTrue((boolean)securityGroup.matches("^sg-\\p{XDigit}{8}$"), (String)("Invalid Security Group Spec: " + securityGroup));
            AmazonEC2 ec2 = (AmazonEC2)this.getClientFactory().getService(AmazonEC2Client.class);
            DescribeSecurityGroupsResult describeSecurityGroupsResult = ec2.describeSecurityGroups(new DescribeSecurityGroupsRequest().withGroupIds(new String[]{securityGroup}));
            if (!describeSecurityGroupsResult.getSecurityGroups().isEmpty()) {
                Predicate<SecurityGroup> predicate = new Predicate<SecurityGroup>(){

                    public boolean apply(SecurityGroup input) {
                        return -1 == input.getGroupName().indexOf(environmentId);
                    }
                };
                return Collections2.filter((Collection)describeSecurityGroupsResult.getSecurityGroups(), (Predicate)predicate).isEmpty();
            }
        }
        if (!(bInvalid = StringUtils.isBlank((String)optionSetting.getValue()))) {
            boolean bl = bInvalid = optionSetting.getNamespace().equals("aws:cloudformation:template:parameter") && optionSetting.getOptionName().equals("AppSource");
        }
        if (!bInvalid) {
            boolean bl = bInvalid = optionSetting.getNamespace().equals("aws:elasticbeanstalk:sns:topics") && optionSetting.getOptionName().equals("Notification Topic ARN");
        }
        if (!bInvalid && StringUtils.isNotBlank((String)environmentId)) {
            bInvalid = optionSetting.getValue().contains(environmentId);
        }
        return bInvalid;
    }

    public String lookupTemplateName(String applicationName, String templateName) {
        if (!this.hasWildcards(StringUtils.defaultString((String)templateName))) {
            return templateName;
        }
        this.getLog().info((CharSequence)String.format("Template Name %s contains wildcards. A Lookup is needed", templateName));
        List<String> configurationTemplates = this.getConfigurationTemplates(applicationName);
        for (String configTemplateName : configurationTemplates) {
            this.getLog().debug((CharSequence)String.format(" * Found Template Name: %s", configTemplateName));
        }
        Pattern templateMask = this.globify(templateName);
        for (String s : configurationTemplates) {
            Matcher m = templateMask.matcher(s);
            if (!m.matches()) continue;
            this.getLog().info((CharSequence)String.format("Selecting: %s", s));
            return s;
        }
        this.getLog().info((CharSequence)"Not found");
        return null;
    }

    protected Pattern globify(String templateName) {
        return Pattern.compile(templateName.replaceAll("\\.", "\\\\.").replaceAll("\\Q*\\E", ".*").replaceAll("\\Q?\\E", "."));
    }

    public boolean hasWildcards(String input) {
        return input.indexOf(42) != -1 || input.indexOf(63) != -1;
    }

    protected List<String> getConfigurationTemplates(String applicationName) {
        List configurationTemplates = ((ApplicationDescription)this.getService().describeApplications(new DescribeApplicationsRequest().withApplicationNames(new String[]{applicationName})).getApplications().get(0)).getConfigurationTemplates();
        Collections.sort(configurationTemplates, new ReverseComparator(String.CASE_INSENSITIVE_ORDER));
        return configurationTemplates;
    }

    public String ensureSuffix(String cname) {
        if (!(cname = StringUtils.defaultString((String)cname)).endsWith(".elasticbeanstalk.com")) {
            cname = cname + ".elasticbeanstalk.com";
        }
        return cname;
    }

    public String ensureSuffixStripped(String cnamePrefix) {
        return StringUtils.defaultString((String)cnamePrefix).replaceAll("\\Q.elasticbeanstalk.com\\E$", "");
    }

    protected String lookupSolutionStack(String solutionStack) {
        if (!this.hasWildcards(solutionStack)) {
            return solutionStack;
        }
        this.getLog().info((CharSequence)("Looking up for solution stacks matching '" + solutionStack + "'"));
        Function<SolutionStackDescription, String> stackTransformer = new Function<SolutionStackDescription, String>(){

            public String apply(SolutionStackDescription input) {
                return input.getSolutionStackName();
            }
        };
        List stackDetails = this.getService().listAvailableSolutionStacks().getSolutionStackDetails();
        Collection solStackList = Collections2.transform((Collection)stackDetails, (Function)stackTransformer);
        final Pattern stackPattern = this.globify(solutionStack);
        ArrayList matchingStacks = new ArrayList(Collections2.filter((Collection)solStackList, (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return stackPattern.matcher(input).matches();
            }
        }));
        Collections.sort(matchingStacks, ComparatorUtils.reversedComparator((Comparator)Collator.getInstance()));
        if (matchingStacks.isEmpty()) {
            throw new IllegalStateException("unable to lookup a solution stack matching '" + solutionStack + "'");
        }
        return (String)matchingStacks.iterator().next();
    }

    public AWSElasticBeanstalkClient getService() {
        AWSElasticBeanstalkClient service = (AWSElasticBeanstalkClient)super.getService();
        if (StringUtils.isNotBlank((String)this.endpointUrl)) {
            service.setEndpoint(this.endpointUrl);
        }
        return service;
    }
}

