/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.beanstalk;

import br.com.ingenieux.mojo.beanstalk.AbstractBeanstalkMojo;
import br.com.ingenieux.mojo.beanstalk.cmd.env.waitfor.WaitForEnvironmentCommand;
import br.com.ingenieux.mojo.beanstalk.cmd.env.waitfor.WaitForEnvironmentContext;
import br.com.ingenieux.mojo.beanstalk.cmd.env.waitfor.WaitForEnvironmentContextBuilder;
import com.amazonaws.services.elasticbeanstalk.model.ApplicationVersionDescription;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentDescription;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.maven.plugin.AbstractMojoExecutionException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractNeedsEnvironmentMojo
extends AbstractBeanstalkMojo {
    public static final Comparator<ConfigurationOptionSetting> COS_COMPARATOR = new Comparator<ConfigurationOptionSetting>(){

        @Override
        public int compare(ConfigurationOptionSetting o1, ConfigurationOptionSetting o2) {
            return new CompareToBuilder().append((Object)o1.getNamespace(), (Object)o2.getNamespace()).append((Object)o1.getOptionName(), (Object)o2.getOptionName()).append((Object)o1.getValue(), (Object)o2.getValue()).toComparison();
        }
    };
    public static final Map<String, ConfigurationOptionSetting> COMMON_PARAMETERS = new TreeMap<String, ConfigurationOptionSetting>(){
        private static final long serialVersionUID = -6380522758234507742L;
        {
            this.put("beanstalk.scalingAvailabilityZones", new ConfigurationOptionSetting("aws:autoscaling:asg", "Availability Zones", ""));
            this.put("beanstalk.scalingCooldown", new ConfigurationOptionSetting("aws:autoscaling:asg", "Cooldown", ""));
            this.put("beanstalk.scalingCustomAvailabilityZones", new ConfigurationOptionSetting("aws:autoscaling:asg", "Custom Availability Zones", ""));
            this.put("beanstalk.availabilityZones", new ConfigurationOptionSetting("aws:autoscaling:asg", "Custom Availability Zones", ""));
            this.put("beanstalk.scalingMinSize", new ConfigurationOptionSetting("aws:autoscaling:asg", "MinSize", ""));
            this.put("beanstalk.scalingMaxSize", new ConfigurationOptionSetting("aws:autoscaling:asg", "MaxSize", ""));
            this.put("beanstalk.keyName", new ConfigurationOptionSetting("aws:autoscaling:launchconfiguration", "EC2KeyName", ""));
            this.put("beanstalk.iamInstanceProfile", new ConfigurationOptionSetting("aws:autoscaling:launchconfiguration", "IamInstanceProfile", ""));
            this.put("beanstalk.imageId", new ConfigurationOptionSetting("aws:autoscaling:launchconfiguration", "ImageId", ""));
            this.put("beanstalk.instanceType", new ConfigurationOptionSetting("aws:autoscaling:launchconfiguration", "InstanceType", ""));
            this.put("beanstalk.monitoringInterval", new ConfigurationOptionSetting("aws:autoscaling:launchconfiguration", "MonitoringInterval", ""));
            this.put("beanstalk.securityGroups", new ConfigurationOptionSetting("aws:autoscaling:launchconfiguration", "SecurityGroups", ""));
            this.put("beanstalk.sshSourceRestriction", new ConfigurationOptionSetting("aws:autoscaling:launchconfiguration", "SSHSourceRestriction", ""));
            this.put("beanstalk.blockDeviceMappings", new ConfigurationOptionSetting("aws:autoscaling:launchconfiguration", "BlockDeviceMappings", ""));
            this.put("beanstalk.rootVolumeType", new ConfigurationOptionSetting("aws:autoscaling:launchconfiguration", "RootVolumeType", ""));
            this.put("beanstalk.rootVolumeSize", new ConfigurationOptionSetting("aws:autoscaling:launchconfiguration", "RootVolumeSize", ""));
            this.put("beanstalk.rootVolumeIOPS", new ConfigurationOptionSetting("aws:autoscaling:launchconfiguration", "RootVolumeIOPS", ""));
            this.put("beanstalk.triggerBreachDuration", new ConfigurationOptionSetting("aws:autoscaling:trigger", "BreachDuration", ""));
            this.put("beanstalk.triggerLowerBreachScaleIncrement", new ConfigurationOptionSetting("aws:autoscaling:trigger", "LowerBreachScaleIncrement", ""));
            this.put("beanstalk.triggerLowerThreshold", new ConfigurationOptionSetting("aws:autoscaling:trigger", "LowerThreshold", ""));
            this.put("beanstalk.triggerMeasureName", new ConfigurationOptionSetting("aws:autoscaling:trigger", "MeasureName", ""));
            this.put("beanstalk.triggerPeriod", new ConfigurationOptionSetting("aws:autoscaling:trigger", "Period", ""));
            this.put("beanstalk.triggerStatistic", new ConfigurationOptionSetting("aws:autoscaling:trigger", "Statistic", ""));
            this.put("beanstalk.triggerUnit", new ConfigurationOptionSetting("aws:autoscaling:trigger", "Unit", ""));
            this.put("beanstalk.triggerUpperBreachScaleIncrement", new ConfigurationOptionSetting("aws:autoscaling:trigger", "UpperBreachScaleIncrement", ""));
            this.put("beanstalk.triggerUpperThreshold", new ConfigurationOptionSetting("aws:autoscaling:trigger", "UpperThreshold", ""));
            this.put("beanstalk.rollingupdateMaxBatchSize", new ConfigurationOptionSetting("aws:autoscaling:updatepolicy:rollingupdate", "MaxBatchSize", ""));
            this.put("beanstalk.rollingupdateMinInstancesInService", new ConfigurationOptionSetting("aws:autoscaling:updatepolicy:rollingupdate", "MinInstancesInService", ""));
            this.put("beanstalk.rollingupdatePauseTime", new ConfigurationOptionSetting("aws:autoscaling:updatepolicy:rollingupdate", "PauseTime", ""));
            this.put("beanstalk.rollingupdateEnabled", new ConfigurationOptionSetting("aws:autoscaling:updatepolicy:rollingupdate", "RollingUpdateEnabled", ""));
            this.put("beanstalk.vpcId", new ConfigurationOptionSetting("aws:ec2:vpc", "VPCId", ""));
            this.put("beanstalk.vpcSubnets", new ConfigurationOptionSetting("aws:ec2:vpc", "Subnets", ""));
            this.put("beanstalk.vpcELBSubnets", new ConfigurationOptionSetting("aws:ec2:vpc", "ELBSubnets", ""));
            this.put("beanstalk.vpcELBScheme", new ConfigurationOptionSetting("aws:ec2:vpc", "ELBScheme", ""));
            this.put("beanstalk.vpcDBSubnets", new ConfigurationOptionSetting("aws:ec2:vpc", "DBSubnets", ""));
            this.put("beanstalk.vpcAssociatePublicIpAddress", new ConfigurationOptionSetting("aws:ec2:vpc", "AssociatePublicIpAddress", ""));
            this.put("beanstalk.applicationHealthCheckURL", new ConfigurationOptionSetting("aws:elasticbeanstalk:application", "Application Healthcheck URL", ""));
            this.put("beanstalk.timeout", new ConfigurationOptionSetting("aws:elasticbeanstalk:command", "Timeout", ""));
            this.put("beanstalk.environmentType", new ConfigurationOptionSetting("aws:elasticbeanstalk:environment", "EnvironmentType", ""));
            this.put("beanstalk.automaticallyTerminateUnhealthyInstances", new ConfigurationOptionSetting("aws:elasticbeanstalk:monitoring", "Automatically Terminate Unhealthy Instances", ""));
            this.put("beanstalk.notificationEndpoint", new ConfigurationOptionSetting("aws:elasticbeanstalk:sns:topics", "Notification Endpoint", ""));
            this.put("beanstalk.notificationProtocol", new ConfigurationOptionSetting("aws:elasticbeanstalk:sns:topics", "Notification Protocol", ""));
            this.put("beanstalk.notificationTopicARN", new ConfigurationOptionSetting("aws:elasticbeanstalk:sns:topics", "Notification Topic ARN", ""));
            this.put("beanstalk.notificationTopicName", new ConfigurationOptionSetting("aws:elasticbeanstalk:sns:topics", "Notification Topic Name", ""));
            this.put("beanstalk.sqsdWorkerQueueUrl", new ConfigurationOptionSetting("aws:elasticbeanstalk:sqsd", "WorkerQueueURL", ""));
            this.put("beanstalk.sqsdHttpPath", new ConfigurationOptionSetting("aws:elasticbeanstalk:sqsd", "HttpPath", ""));
            this.put("beanstalk.sqsdMimeType", new ConfigurationOptionSetting("aws:elasticbeanstalk:sqsd", "MimeType", ""));
            this.put("beanstalk.sqsdHttpConnections", new ConfigurationOptionSetting("aws:elasticbeanstalk:sqsd", "HttpConnections", ""));
            this.put("beanstalk.sqsdConnectTimeout", new ConfigurationOptionSetting("aws:elasticbeanstalk:sqsd", "ConnectTimeout", ""));
            this.put("beanstalk.sqsdInactivityTimeout", new ConfigurationOptionSetting("aws:elasticbeanstalk:sqsd", "InactivityTimeout", ""));
            this.put("beanstalk.sqsdVisibilityTimeout", new ConfigurationOptionSetting("aws:elasticbeanstalk:sqsd", "VisibilityTimeout", ""));
            this.put("beanstalk.sqsdRetentionPeriod", new ConfigurationOptionSetting("aws:elasticbeanstalk:sqsd", "RetentionPeriod", ""));
            this.put("beanstalk.sqsdMaxRetries", new ConfigurationOptionSetting("aws:elasticbeanstalk:sqsd", "MaxRetries", ""));
            this.put("beanstalk.healthcheckHealthyThreshold", new ConfigurationOptionSetting("aws:elb:healthcheck", "HealthyThreshold", ""));
            this.put("beanstalk.healthcheckInterval", new ConfigurationOptionSetting("aws:elb:healthcheck", "Interval", ""));
            this.put("beanstalk.healthcheckTimeout", new ConfigurationOptionSetting("aws:elb:healthcheck", "Timeout", ""));
            this.put("beanstalk.healthcheckUnhealthyThreshold", new ConfigurationOptionSetting("aws:elb:healthcheck", "UnhealthyThreshold", ""));
            this.put("beanstalk.loadBalancerHTTPPort", new ConfigurationOptionSetting("aws:elb:loadbalancer", "LoadBalancerHTTPPort", ""));
            this.put("beanstalk.loadBalancerPortProtocol", new ConfigurationOptionSetting("aws:elb:loadbalancer", "LoadBalancerPortProtocol", ""));
            this.put("beanstalk.loadBalancerHTTPSPort", new ConfigurationOptionSetting("aws:elb:loadbalancer", "LoadBalancerHTTPSPort", ""));
            this.put("beanstalk.loadBalancerSSLPortProtocol", new ConfigurationOptionSetting("aws:elb:loadbalancer", "LoadBalancerSSLPortProtocol", ""));
            this.put("beanstalk.loadBalancerSSLCertificateId", new ConfigurationOptionSetting("aws:elb:loadbalancer", "SSLCertificateId", ""));
            this.put("beanstalk.stickinessCookieExpiration", new ConfigurationOptionSetting("aws:elb:policies", "Stickiness Cookie Expiration", ""));
            this.put("beanstalk.stickinessPolicy", new ConfigurationOptionSetting("aws:elb:policies", "Stickiness Policy", ""));
            this.put("beanstalk.dbAllocatedStorage", new ConfigurationOptionSetting("aws:rds:dbinstance", "DBAllocatedStorage", ""));
            this.put("beanstalk.dbDeletionPolicy", new ConfigurationOptionSetting("aws:rds:dbinstance", "DBDeletionPolicy", ""));
            this.put("beanstalk.dbEngine", new ConfigurationOptionSetting("aws:rds:dbinstance", "DBEngine", ""));
            this.put("beanstalk.dbEngineVersion", new ConfigurationOptionSetting("aws:rds:dbinstance", "DBEngineVersion", ""));
            this.put("beanstalk.dbInstanceClass", new ConfigurationOptionSetting("aws:rds:dbinstance", "DBInstanceClass", ""));
            this.put("beanstalk.dbPassword", new ConfigurationOptionSetting("aws:rds:dbinstance", "DBPassword", ""));
            this.put("beanstalk.dbSnapshotIdentifier", new ConfigurationOptionSetting("aws:rds:dbinstance", "DBSnapshotIdentifier", ""));
            this.put("beanstalk.dbUser", new ConfigurationOptionSetting("aws:rds:dbinstance", "DBUser", ""));
            this.put("beanstalk.dbMultiAZDatabase", new ConfigurationOptionSetting("aws:rds:dbinstance", "MultiAZDatabase", ""));
            this.put("beanstalk.environmentAwsSecretKey", new ConfigurationOptionSetting("aws:elasticbeanstalk:application:environment", "AWS_SECRET_KEY", ""));
            this.put("beanstalk.environmentAwsAccessKeyId", new ConfigurationOptionSetting("aws:elasticbeanstalk:application:environment", "AWS_ACCESS_KEY_ID", ""));
            this.put("beanstalk.environmentJdbcConnectionString", new ConfigurationOptionSetting("aws:elasticbeanstalk:application:environment", "JDBC_CONNECTION_STRING", ""));
            this.put("beanstalk.environmentParam1", new ConfigurationOptionSetting("aws:elasticbeanstalk:application:environment", "PARAM1", ""));
            this.put("beanstalk.environmentParam2", new ConfigurationOptionSetting("aws:elasticbeanstalk:application:environment", "PARAM2", ""));
            this.put("beanstalk.environmentParam3", new ConfigurationOptionSetting("aws:elasticbeanstalk:application:environment", "PARAM3", ""));
            this.put("beanstalk.environmentParam4", new ConfigurationOptionSetting("aws:elasticbeanstalk:application:environment", "PARAM4", ""));
            this.put("beanstalk.environmentParam5", new ConfigurationOptionSetting("aws:elasticbeanstalk:application:environment", "PARAM5", ""));
            this.put("beanstalk.logPublicationControl", new ConfigurationOptionSetting("aws:elasticbeanstalk:hostmanager", "LogPublicationControl", ""));
            this.put("beanstalk.jvmOptions", new ConfigurationOptionSetting("aws:elasticbeanstalk:container:tomcat:jvmoptions", "JVM Options", ""));
            this.put("beanstalk.jvmXmx", new ConfigurationOptionSetting("aws:elasticbeanstalk:container:tomcat:jvmoptions", "Xmx", ""));
            this.put("beanstalk.jvmMaxPermSize", new ConfigurationOptionSetting("aws:elasticbeanstalk:container:tomcat:jvmoptions", "XX:MaxPermSize", ""));
            this.put("beanstalk.jvmXms", new ConfigurationOptionSetting("aws:elasticbeanstalk:container:tomcat:jvmoptions", "Xms", ""));
            this.put("beanstalk.phpDocumentRoot", new ConfigurationOptionSetting("aws:elasticbeanstalk:container:php:phpini", "document_root", ""));
            this.put("beanstalk.phpMemoryLimit", new ConfigurationOptionSetting("aws:elasticbeanstalk:container:php:phpini", "memory_limit", ""));
            this.put("beanstalk.phpZlibOutputCompression", new ConfigurationOptionSetting("aws:elasticbeanstalk:container:php:phpini", "zlib.output_compression", ""));
            this.put("beanstalk.phpAllowUrlFopen", new ConfigurationOptionSetting("aws:elasticbeanstalk:container:php:phpini", "allow_url_fopen", ""));
            this.put("beanstalk.phpDisplayErrors", new ConfigurationOptionSetting("aws:elasticbeanstalk:container:php:phpini", "display_errors", ""));
            this.put("beanstalk.phpMaxExecutionTime", new ConfigurationOptionSetting("aws:elasticbeanstalk:container:php:phpini", "max_execution_time", ""));
            this.put("beanstalk.phpComposerOptions", new ConfigurationOptionSetting("aws:elasticbeanstalk:container:php:phpini", "composer_options", ""));
        }
    };
    @Parameter(property="beanstalk.applicationName", defaultValue="${project.artifactId}", required=true)
    protected String applicationName;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(property="beanstalk.environmentRef", defaultValue="${project.artifactId}.elasticbeanstalk.com")
    protected String environmentRef;
    protected EnvironmentDescription curEnv;

    protected void configure() {
        try {
            this.curEnv = super.lookupEnvironment(this.applicationName, this.environmentRef);
        }
        catch (MojoExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    protected EnvironmentDescription getEnvironmentForCNamePrefix(String applicationName, String cnamePrefix) {
        for (EnvironmentDescription env : this.getEnvironmentsFor(applicationName)) {
            String cnameToMatch = cnamePrefix + ".elasticbeanstalk.com";
            if (this.verbose) {
                this.getLog().info((CharSequence)("Trying to match " + cnameToMatch + " with " + env.getCNAME()));
            }
            if (!env.getCNAME().equalsIgnoreCase(cnameToMatch)) continue;
            return env;
        }
        return null;
    }

    protected Collection<EnvironmentDescription> getEnvironmentsFor(String applicationName) {
        DescribeEnvironmentsRequest req = new DescribeEnvironmentsRequest().withApplicationName(applicationName).withIncludeDeleted(Boolean.valueOf(false));
        return this.getService().describeEnvironments(req).getEnvironments();
    }

    protected ConfigurationOptionSetting[] introspectOptionSettings() {
        TreeSet<ConfigurationOptionSetting> configOptionSetting = new TreeSet<ConfigurationOptionSetting>(COS_COMPARATOR);
        Properties properties = new Properties();
        if (null != this.project) {
            for (Map.Entry<Object, Object> entry : this.project.getProperties().entrySet()) {
                if (!("" + entry.getKey()).startsWith("beanstalk")) continue;
                properties.put(entry.getKey(), entry.getValue());
            }
        }
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            if (!("" + entry.getKey()).startsWith("beanstalk")) continue;
            properties.put(entry.getKey(), entry.getValue());
        }
        for (Object o : properties.keySet()) {
            String k = "" + o;
            if (k.startsWith("beanstalk.env.aws.")) {
                String realKey = k.substring("beanstalk.env.".length());
                String v = "" + properties.get(k);
                ArrayList<String> elements = new ArrayList<String>(Arrays.asList(realKey.split("\\.")));
                String namespace = StringUtils.join(elements.subList(0, -1 + elements.size()), (String)":");
                String optionName = (String)elements.get(-1 + elements.size());
                this.getLog().info((CharSequence)("importing " + k + " as " + namespace + ":" + optionName + "=" + v));
                configOptionSetting.add(new ConfigurationOptionSetting().withNamespace(namespace).withOptionName(optionName).withValue(v));
                continue;
            }
            if (!COMMON_PARAMETERS.containsKey(k)) continue;
            String v = "" + properties.get(k);
            String namespace = COMMON_PARAMETERS.get(k).getNamespace();
            String optionName = COMMON_PARAMETERS.get(k).getOptionName();
            this.getLog().info((CharSequence)("Found alias " + k + " for " + namespace + ":" + optionName + "(value=" + v + ")"));
            configOptionSetting.add(new ConfigurationOptionSetting().withNamespace(namespace).withOptionName(optionName).withValue(v));
        }
        return configOptionSetting.toArray(new ConfigurationOptionSetting[configOptionSetting.size()]);
    }

    protected void waitForNotUpdating() throws AbstractMojoExecutionException, MojoFailureException, MojoExecutionException {
        WaitForEnvironmentContext context = ((WaitForEnvironmentContextBuilder)((WaitForEnvironmentContextBuilder)((WaitForEnvironmentContextBuilder)((WaitForEnvironmentContextBuilder)new WaitForEnvironmentContextBuilder().withApplicationName(this.applicationName)).withStatusToWaitFor("!Updating")).withTimeoutMins(2)).withEnvironmentRef(this.environmentRef)).build();
        WaitForEnvironmentCommand command = new WaitForEnvironmentCommand(this);
        command.execute(context);
    }

    protected String lookupVersionLabel(String appName, String versionLabel) {
        if (StringUtils.isBlank((String)versionLabel)) {
            DescribeApplicationVersionsResult appVersionsResult = this.getService().describeApplicationVersions(new DescribeApplicationVersionsRequest().withApplicationName(appName));
            ArrayList appVersionList = new ArrayList(appVersionsResult.getApplicationVersions());
            Collections.sort(appVersionList, new Comparator<ApplicationVersionDescription>(){

                @Override
                public int compare(ApplicationVersionDescription o1, ApplicationVersionDescription o2) {
                    return new CompareToBuilder().append((Object)o2.getDateUpdated(), (Object)o1.getDateUpdated()).append((Object)o2.getDateCreated(), (Object)o1.getDateUpdated()).toComparison();
                }
            });
            if (appVersionList.isEmpty()) {
                String message = "No version label supplied **AND** no app versions available.";
                this.getLog().info((CharSequence)message);
                throw new IllegalStateException(message);
            }
            versionLabel = ((ApplicationVersionDescription)appVersionList.get(0)).getVersionLabel();
            this.getLog().info((CharSequence)("Using latest available application version " + versionLabel));
        }
        return versionLabel;
    }
}

