/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.beanstalk.bg;

import br.com.ingenieux.mojo.beanstalk.AbstractNeedsEnvironmentMojo;
import br.com.ingenieux.mojo.beanstalk.cmd.env.update.UpdateEnvironmentCommand;
import br.com.ingenieux.mojo.beanstalk.cmd.env.update.UpdateEnvironmentContextBuilder;
import br.com.ingenieux.mojo.beanstalk.cmd.env.waitfor.WaitForEnvironmentCommand;
import br.com.ingenieux.mojo.beanstalk.cmd.env.waitfor.WaitForEnvironmentContextBuilder;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentDescription;
import com.amazonaws.services.elasticbeanstalk.model.SwapEnvironmentCNAMEsRequest;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="blue-green")
public class BluegreenDeploymentMojo
extends AbstractNeedsEnvironmentMojo {
    @Parameter(property="beanstalk.environmentNamePrefix", required=true, defaultValue="${beanstalk.environmentName}")
    protected String environmentNamePrefix;
    @Parameter(property="beanstalk.versionLabel", defaultValue="${project.version}-${maven.build.timestamp}")
    String versionLabel;

    protected Object executeInternal() throws Exception {
        this.versionLabel = this.lookupVersionLabel(this.applicationName, this.versionLabel);
        this.getLog().info((CharSequence)String.format("Using version %s", this.versionLabel));
        Collection<EnvironmentDescription> envs = new WaitForEnvironmentCommand(this).lookupInternal(((WaitForEnvironmentContextBuilder)((WaitForEnvironmentContextBuilder)new WaitForEnvironmentContextBuilder().withApplicationName(this.applicationName)).withEnvironmentRef(this.environmentNamePrefix + "*")).build());
        if (envs.size() > 2) {
            Collection environmentList = Collections2.transform(envs, (Function)new Function<EnvironmentDescription, String>(){

                public String apply(EnvironmentDescription input) {
                    return String.format("%s[%s]", input.getEnvironmentId(), input.getEnvironmentName());
                }
            });
            String message = "Ooops. There are multiple environments matching the lookup spec: " + environmentList;
            this.getLog().warn((CharSequence)message);
            this.getLog().warn((CharSequence)"Will pick one at random anyway as long as it uses WebServer tier name");
        }
        String otherEnvId = null;
        for (EnvironmentDescription e : envs) {
            if (e.getEnvironmentId().equals(this.curEnv.getEnvironmentId()) || !"WebServer".equals(e.getTier().getName())) continue;
            otherEnvId = e.getEnvironmentId();
            break;
        }
        this.getLog().info((CharSequence)String.format("(Green) Environment with environmentId['%s'] will be prepared once its ready to update", this.curEnv.getEnvironmentId()));
        new WaitForEnvironmentCommand(this).execute(((WaitForEnvironmentContextBuilder)((WaitForEnvironmentContextBuilder)((WaitForEnvironmentContextBuilder)new WaitForEnvironmentContextBuilder().withStatusToWaitFor("Ready")).withApplicationName(this.applicationName)).withEnvironmentRef(this.curEnv.getEnvironmentId())).build());
        this.getLog().info((CharSequence)String.format("(Blue) Environment with environmentId['%s'] will be prepared once its ready to update", otherEnvId));
        new WaitForEnvironmentCommand(this).execute(((WaitForEnvironmentContextBuilder)((WaitForEnvironmentContextBuilder)((WaitForEnvironmentContextBuilder)new WaitForEnvironmentContextBuilder().withStatusToWaitFor("Ready")).withApplicationName(this.applicationName)).withEnvironmentRef(otherEnvId)).build());
        this.getLog().info((CharSequence)String.format("(Blue) Updating environmentId to version %s", this.versionLabel));
        new UpdateEnvironmentCommand(this).execute(((UpdateEnvironmentContextBuilder)((UpdateEnvironmentContextBuilder)new UpdateEnvironmentContextBuilder().withEnvironmentId(otherEnvId)).withVersionLabel(this.versionLabel)).build());
        this.getLog().info((CharSequence)String.format("(Blue) Waiting for environmentId['%s'] to get ready and green prior to switching", otherEnvId));
        new WaitForEnvironmentCommand(this).execute(((WaitForEnvironmentContextBuilder)((WaitForEnvironmentContextBuilder)((WaitForEnvironmentContextBuilder)((WaitForEnvironmentContextBuilder)new WaitForEnvironmentContextBuilder().withStatusToWaitFor("Ready")).withApplicationName(this.applicationName)).withHealth("Green")).withEnvironmentRef(otherEnvId)).build());
        this.getLog().info((CharSequence)String.format("Ok. Switching", new Object[0]));
        this.getService().swapEnvironmentCNAMEs(new SwapEnvironmentCNAMEsRequest().withDestinationEnvironmentId(this.curEnv.getEnvironmentId()).withSourceEnvironmentId(otherEnvId));
        this.getLog().info((CharSequence)String.format("Done.", new Object[0]));
        return null;
    }
}

