/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.beanstalk.bundle;

import br.com.ingenieux.mojo.beanstalk.AbstractNeedsEnvironmentMojo;
import br.com.ingenieux.mojo.beanstalk.bundle.RequestSigner;
import com.amazonaws.services.elasticbeanstalk.model.ApplicationVersionDescription;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsResult;
import java.io.File;
import java.util.Date;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;

@Mojo(name="fast-deploy")
public class FastDeployMojo
extends AbstractNeedsEnvironmentMojo {
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}")
    File sourceDirectory;
    @Parameter(property="beanstalk.stagingDirectory", defaultValue="${project.basedir}/tmp-git-deployment-staging")
    File stagingDirectory;
    @Parameter(property="beanstalk.useStagingDirectory", defaultValue="false")
    boolean useStagingDirectory = false;
    @Parameter(defaultValue="${project}")
    MavenProject project;
    @Parameter(property="beanstalk.versionDescription", defaultValue="Update from fast-deploy")
    String versionDescription;
    @Parameter(property="beanstalk.skipEnvironmentUpdate", defaultValue="false")
    boolean skipEnvironmentUpdate = false;
    @Parameter(property="beanstalk.silentUpload", defaultValue="false")
    boolean silentUpload = false;

    @Override
    protected void configure() {
        try {
            super.configure();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Object executeInternal() throws Exception {
        Git git = this.getGitRepo();
        String versionLabel = null;
        String commitId = null;
        Ref masterRef = git.getRepository().getRef("master");
        if (null != masterRef) {
            commitId = ObjectId.toString((ObjectId)masterRef.getObjectId());
        }
        Status status = git.status().call();
        boolean pushAhead = false;
        if (null != commitId && status.isClean()) {
            versionLabel = this.lookupVersionLabelForCommitId(commitId);
            if (null == versionLabel) {
                this.getLog().info((CharSequence)"No Changes. However, we've didn't get something close in AWS Elastic Beanstalk and we're pushing ahead");
                pushAhead = true;
            } else {
                this.getLog().info((CharSequence)"No Changes. However, we've got something close in AWS Elastic Beanstalk and we're continuing");
                this.project.getProperties().put("beanstalk.versionLabel", versionLabel);
                return null;
            }
        }
        if (!pushAhead) {
            git.add().setUpdate(true).addFilepattern(".").call();
            AddCommand addCommand = git.add();
            if (!status.getUntracked().isEmpty()) {
                for (String s : status.getUntracked()) {
                    this.getLog().info((CharSequence)("Adding file " + s));
                    addCommand.addFilepattern(s);
                }
                addCommand.call();
            }
            git.commit().setAll(true).setMessage(this.versionDescription).call();
            masterRef = git.getRepository().getRef("master");
            commitId = ObjectId.toString((ObjectId)masterRef.getObjectId());
        }
        String environmentName = null;
        if (null != this.curEnv && !this.skipEnvironmentUpdate) {
            environmentName = this.curEnv.getEnvironmentName();
        }
        String remote = new RequestSigner(this.getAWSCredentials(), this.applicationName, this.regionName, commitId, environmentName, new Date()).getPushUrl();
        this.getLog().info((CharSequence)("Using remote: " + remote));
        PushCommand cmd = git.push();
        if (!this.silentUpload) {
            cmd.setProgressMonitor((ProgressMonitor)new TextProgressMonitor());
        }
        Iterable pushResults = null;
        try {
            pushResults = cmd.setRefSpecs(new RefSpec[]{new RefSpec("HEAD:refs/heads/master")}).setForce(true).setRemote(remote).call();
        }
        catch (Exception exc) {
            this.getLog().debug((CharSequence)"(Actually Expected) Exception", (Throwable)exc);
        }
        if (null != pushResults) {
            for (PushResult pushResult : pushResults) {
                this.getLog().debug((CharSequence)(" * " + pushResult.getMessages()));
            }
        }
        if (null != (versionLabel = this.lookupVersionLabelForCommitId(commitId))) {
            this.getLog().info((CharSequence)("Deployed version " + versionLabel));
            this.project.getProperties().put("beanstalk.versionLabel", versionLabel);
        } else {
            this.getLog().warn((CharSequence)"No version found. Ignoring.");
        }
        return null;
    }

    private String lookupVersionLabelForCommitId(String commitId) {
        String versionLabel = null;
        String prefixToLookup = String.format("git-%s-", commitId);
        DescribeApplicationVersionsResult describeApplicationVersions = this.getService().describeApplicationVersions(new DescribeApplicationVersionsRequest().withApplicationName(this.applicationName));
        for (ApplicationVersionDescription avd : describeApplicationVersions.getApplicationVersions()) {
            if (!avd.getVersionLabel().startsWith(prefixToLookup)) continue;
            versionLabel = avd.getVersionLabel();
            break;
        }
        return versionLabel;
    }

    private Git getGitRepo() throws Exception {
        Git git = null;
        if (!this.useStagingDirectory) {
            File gitRepo = new File(this.sourceDirectory, ".git");
            git = !gitRepo.exists() ? Git.init().setDirectory(this.sourceDirectory).call() : Git.open((File)gitRepo);
        } else {
            File gitRepo = this.stagingDirectory;
            Repository r = null;
            RepositoryBuilder b = (RepositoryBuilder)((RepositoryBuilder)new RepositoryBuilder().setGitDir(this.stagingDirectory)).setWorkTree(this.sourceDirectory);
            if (!gitRepo.exists()) {
                gitRepo.getParentFile().mkdirs();
                r = b.build();
                r.create();
            } else {
                r = b.build();
            }
            git = Git.wrap((Repository)r);
        }
        return git;
    }
}

