/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.beanstalk.bundle;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;

public class RequestSigner {
    public static final SimpleDateFormat DATE_TIME_FORMAT = new SimpleDateFormat("yyyyMMdd'T'HHmmss");
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd");
    private static final String TERMINATOR = "aws4_request";
    private static final String SCHEME = "AWS4";
    private static final String AWS_ALGORITHM = "HMAC-SHA256";
    AWSCredentials awsCredentials;
    String applicationId;
    String region;
    String commitId;
    String environmentName;
    Date date;
    String service = "devtools";
    private String strDate;
    private String strDateTime;

    public RequestSigner(AWSCredentialsProvider awsCredentials, String applicationId, String region, String commitId, String environmentName, Date date) {
        this.awsCredentials = awsCredentials.getCredentials();
        this.applicationId = applicationId;
        this.region = region;
        this.commitId = commitId;
        this.environmentName = environmentName;
        this.date = date;
    }

    public String getPushUrl() {
        this.strDate = DATE_FORMAT.format(this.date);
        this.strDateTime = DATE_TIME_FORMAT.format(this.date);
        String user = this.awsCredentials.getAWSAccessKeyId();
        String host = String.format("git.elasticbeanstalk.%s.amazonaws.com", this.region);
        String path = String.format("/v1/repos/%s/commitid/%s", this.hexEncode(this.applicationId), this.hexEncode(this.commitId));
        if (StringUtils.isNotBlank((String)this.environmentName)) {
            path = path + String.format("/environment/%s", this.hexEncode(this.environmentName));
        }
        String scope = String.format("%s/%s/%s/%s", this.strDate, this.region, this.service, TERMINATOR);
        StringBuilder stringToSign = new StringBuilder();
        stringToSign.append(String.format("%s-%s\n%s\n%s\n", SCHEME, AWS_ALGORITHM, this.strDateTime, scope));
        stringToSign.append(DigestUtils.sha256Hex((byte[])String.format("GIT\n%s\n\nhost:%s\n\nhost\n", path, host).getBytes()));
        byte[] key = this.deriveKey();
        byte[] digest = this.hash(key, stringToSign.toString());
        String signature = Hex.encodeHexString((byte[])digest);
        String password = this.strDateTime.concat("Z").concat(signature);
        String returnUrl = String.format("https://%s:%s@%s%s", user, password, host, path);
        return returnUrl;
    }

    private byte[] deriveKey() {
        String secret = SCHEME.concat(this.awsCredentials.getAWSSecretKey());
        byte[] kSecret = secret.getBytes();
        byte[] kDate = this.hash(kSecret, this.strDate);
        byte[] kRegion = this.hash(kDate, this.region);
        byte[] kService = this.hash(kRegion, this.service);
        byte[] key = this.hash(kService, TERMINATOR);
        return key;
    }

    private byte[] hash(byte[] kSecret, String obj) {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(kSecret, "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(keySpec);
            return mac.doFinal(obj.getBytes("UTF-8"));
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    private String hexEncode(String obj) {
        return Hex.encodeHexString((byte[])obj.getBytes());
    }

    static {
        SimpleTimeZone timezone = new SimpleTimeZone(0, "UTC");
        DATE_TIME_FORMAT.setTimeZone(timezone);
        DATE_FORMAT.setTimeZone(timezone);
    }
}

