/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.beanstalk.bundle;

import br.com.ingenieux.mojo.aws.util.BeanstalkerS3Client;
import br.com.ingenieux.mojo.beanstalk.AbstractBeanstalkMojo;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="upload-source-bundle")
public class UploadSourceBundleMojo
extends AbstractBeanstalkMojo {
    @Parameter(property="beanstalk.s3Bucket")
    String s3Bucket;
    @Parameter(property="beanstalk.s3Key", defaultValue="${project.artifactId}/${project.build.finalName}-${beanstalk.versionLabel}.${project.packaging}", required=true)
    String s3Key;
    @Parameter(property="beanstalk.multipartUpload", defaultValue="true")
    boolean multipartUpload = false;
    @Parameter(property="beanstalk.artifactFile", defaultValue="${project.build.directory}/${project.build.finalName}.${project.packaging}", required=true)
    File artifactFile;
    @Parameter(property="beanstalk.silentUpload", defaultValue="false")
    boolean silentUpload = false;
    @Parameter(property="beanstalk.versionLabel", required=true)
    String versionLabel;
    @Parameter(defaultValue="${project}")
    MavenProject project;

    protected Object executeInternal() throws Exception {
        String path = this.artifactFile.getPath();
        if (!(path.endsWith(".war") || path.endsWith(".jar") || path.endsWith(".zip"))) {
            this.getLog().warn((CharSequence)"Not a war/jar/zip file. Skipping");
            return null;
        }
        if (!this.artifactFile.exists()) {
            throw new MojoFailureException("Artifact File does not exist! (file=" + path + ")");
        }
        BeanstalkerS3Client client = new BeanstalkerS3Client(this.getAWSCredentials(), this.getClientConfiguration(), this.getRegion());
        client.setMultipartUpload(this.multipartUpload);
        client.setSilentUpload(this.silentUpload);
        if (StringUtils.isBlank((String)this.s3Bucket)) {
            this.getLog().info((CharSequence)"S3 Bucket not defined.");
            this.s3Bucket = this.getService().createStorageLocation().getS3Bucket();
            this.getLog().info((CharSequence)("Using defaults, like: " + this.s3Bucket));
            this.project.getProperties().put("beanstalk.s3Bucket", this.s3Bucket);
        }
        this.getLog().info((CharSequence)("Target Path: s3://" + this.s3Bucket + "/" + this.s3Key));
        this.getLog().info((CharSequence)("Uploading artifact file: " + path));
        PutObjectResult result = client.putObject(new PutObjectRequest(this.s3Bucket, this.s3Key, this.artifactFile));
        this.getLog().info((CharSequence)"Artifact Uploaded");
        this.project.getProperties().put("beanstalk.s3Key", this.s3Key);
        return result;
    }
}

