/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.beanstalk.cmd;

import br.com.ingenieux.mojo.beanstalk.AbstractBeanstalkMojo;
import br.com.ingenieux.mojo.beanstalk.cmd.Command;
import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public abstract class BaseCommand<I, O>
implements Command<I, O> {
    protected Log logger;
    protected AWSElasticBeanstalkClient service;
    protected AbstractBeanstalkMojo parentMojo;

    protected BaseCommand(AbstractBeanstalkMojo parentMojo) throws MojoExecutionException {
        this.parentMojo = parentMojo;
        this.service = parentMojo.getService();
        this.logger = parentMojo.getLog();
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void debug(CharSequence message, Object ... args) {
        this.logger.debug((CharSequence)String.format("" + message, args));
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void info(CharSequence message, Object ... args) {
        this.logger.info((CharSequence)String.format("" + message, args));
    }

    @Override
    public final O execute(I context) throws MojoFailureException, MojoExecutionException {
        try {
            return this.executeInternal(context);
        }
        catch (Exception exc) {
            this.handleException(exc);
            throw new RuntimeException("Unlikely");
        }
    }

    private void handleException(Exception exc) throws MojoExecutionException, MojoFailureException {
        this.parentMojo.handleException(exc);
    }

    protected abstract O executeInternal(I var1) throws Exception;
}

