/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.beanstalk.cmd.dns;

import br.com.ingenieux.mojo.beanstalk.AbstractNeedsEnvironmentMojo;
import br.com.ingenieux.mojo.beanstalk.cmd.BaseCommand;
import br.com.ingenieux.mojo.beanstalk.cmd.dns.BindDomainsContext;
import br.com.ingenieux.mojo.beanstalk.util.ConfigUtil;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationSettingsDescription;
import com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationSettingsResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentDescription;
import com.amazonaws.services.elasticbeanstalk.model.LoadBalancer;
import com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancing;
import com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersRequest;
import com.amazonaws.services.elasticloadbalancing.model.LoadBalancerDescription;
import com.amazonaws.services.route53.AmazonRoute53;
import com.amazonaws.services.route53.AmazonRoute53Client;
import com.amazonaws.services.route53.model.AliasTarget;
import com.amazonaws.services.route53.model.Change;
import com.amazonaws.services.route53.model.ChangeAction;
import com.amazonaws.services.route53.model.ChangeBatch;
import com.amazonaws.services.route53.model.ChangeResourceRecordSetsRequest;
import com.amazonaws.services.route53.model.HostedZone;
import com.amazonaws.services.route53.model.ListResourceRecordSetsRequest;
import com.amazonaws.services.route53.model.ListResourceRecordSetsResult;
import com.amazonaws.services.route53.model.RRType;
import com.amazonaws.services.route53.model.ResourceRecord;
import com.amazonaws.services.route53.model.ResourceRecordSet;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.maven.plugin.AbstractMojoExecutionException;
import org.apache.maven.plugin.MojoExecutionException;

public class BindDomainsCommand
extends BaseCommand<BindDomainsContext, Void> {
    private final AmazonRoute53 r53;
    private final AmazonEC2 ec2;
    private final AmazonElasticLoadBalancing elb;

    public BindDomainsCommand(AbstractNeedsEnvironmentMojo parentMojo) throws AbstractMojoExecutionException {
        super(parentMojo);
        try {
            this.r53 = (AmazonRoute53)parentMojo.getClientFactory().getService(AmazonRoute53Client.class);
            this.ec2 = (AmazonEC2)parentMojo.getClientFactory().getService(AmazonEC2Client.class);
            this.elb = (AmazonElasticLoadBalancing)parentMojo.getClientFactory().getService(AmazonElasticLoadBalancingClient.class);
        }
        catch (Exception exc) {
            throw new MojoExecutionException("Failure", exc);
        }
    }

    protected boolean isSingleInstance(EnvironmentDescription env) {
        Validate.isTrue((boolean)"WebServer".equals(env.getTier().getName()), (String)"Not a Web Server environment!");
        DescribeConfigurationSettingsResult describeConfigurationSettingsResult = this.parentMojo.getService().describeConfigurationSettings(new DescribeConfigurationSettingsRequest().withApplicationName(env.getApplicationName()).withEnvironmentName(env.getEnvironmentName()));
        Validate.isTrue((1 == describeConfigurationSettingsResult.getConfigurationSettings().size() ? 1 : 0) != 0, (String)"There should be one environment");
        List optionSettings = ((ConfigurationSettingsDescription)describeConfigurationSettingsResult.getConfigurationSettings().get(0)).getOptionSettings();
        for (ConfigurationOptionSetting optionSetting : optionSettings) {
            if (!ConfigUtil.optionSettingMatchesP(optionSetting, "aws:elasticbeanstalk:environment", "EnvironmentType")) continue;
            return "SingleInstance".equals(optionSetting.getValue());
        }
        throw new IllegalStateException("Unreachable code!");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Void executeInternal(BindDomainsContext ctx) throws Exception {
        LinkedHashMap<Object, Object> recordsToAssign = new LinkedHashMap<Object, Object>();
        ctx.singleInstance = this.isSingleInstance(ctx.getCurEnv());
        for (String string : ctx.getDomains()) {
            void var6_25;
            void var5_12;
            String string2 = this.formatDomain(string);
            Object var6_26 = null;
            if (-1 != string2.indexOf(58)) {
                String[] pair = string2.split(":", 2);
                String string3 = this.formatDomain(pair[0]);
                String string4 = StringUtils.strip((String)pair[1], (String)".");
            }
            recordsToAssign.put(var5_12, var6_25);
        }
        Validate.isTrue((recordsToAssign.size() > 0 ? 1 : 0) != 0, (String)"No Domains Supplied!");
        if (this.isInfoEnabled()) {
            this.info("Domains to Map to Environment (cnamePrefix='%s')", ctx.getCurEnv().getCNAME());
            for (Map.Entry entry : recordsToAssign.entrySet()) {
                String string = (String)entry.getKey();
                String string5 = (String)entry.getValue();
                String message = String.format(" * Domain: %s", string);
                if (null != string5) {
                    message = message + " (and using zoneId " + string5 + ")";
                }
                this.info(message, new Object[0]);
            }
        }
        LinkedHashMap<String, HostedZone> hostedZoneMapping = new LinkedHashMap<String, HostedZone>();
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (Map.Entry entry : recordsToAssign.entrySet()) {
            if (null != entry.getValue()) continue;
            linkedHashSet.add(entry.getKey());
        }
        for (HostedZone hostedZone : this.r53.listHostedZones().getHostedZones()) {
            String id = hostedZone.getId();
            String name = hostedZone.getName();
            hostedZoneMapping.put(id, hostedZone);
            if (!linkedHashSet.contains(name)) continue;
            if (this.isInfoEnabled()) {
                this.info("Mapping Domain %s to R53 Zone Id %s", name, id);
            }
            recordsToAssign.put(name, id);
            linkedHashSet.remove(name);
        }
        Validate.isTrue((boolean)linkedHashSet.isEmpty(), (String)("Domains not resolved: " + StringUtils.join(linkedHashSet, (String)"; ")));
        for (Map.Entry entry : recordsToAssign.entrySet()) {
            String string = (String)entry.getKey();
            String zoneId = (String)entry.getValue();
            HostedZone hostedZone = (HostedZone)hostedZoneMapping.get(zoneId);
            Validate.notNull((Object)hostedZone, (String)String.format("Unknown Hosted Zone Id: %s for Record: %s", zoneId, string));
            Validate.isTrue((boolean)string.endsWith(hostedZone.getName()), (String)String.format("Record %s does not map to zoneId %s (domain: %s)", string, zoneId, hostedZone.getName()));
        }
        if (!ctx.singleInstance) {
            String string = ((LoadBalancer)this.parentMojo.getService().describeEnvironmentResources(new DescribeEnvironmentResourcesRequest().withEnvironmentId(ctx.getCurEnv().getEnvironmentId())).getEnvironmentResources().getLoadBalancers().get(0)).getName();
            DescribeLoadBalancersRequest describeLoadBalancersRequest = new DescribeLoadBalancersRequest(Arrays.asList(string));
            List list = this.elb.describeLoadBalancers(describeLoadBalancersRequest).getLoadBalancerDescriptions();
            Validate.isTrue((1 == list.size() ? 1 : 0) != 0, (String)"Unexpected number of Load Balancers returned");
            ctx.elbHostedZoneId = ((LoadBalancerDescription)list.get(0)).getCanonicalHostedZoneNameID();
            if (this.isInfoEnabled()) {
                this.info(String.format("Using ELB Canonical Hosted Zone Name Id %s", ctx.elbHostedZoneId), new Object[0]);
            }
        }
        for (Map.Entry entry : recordsToAssign.entrySet()) {
            this.assignDomain(ctx, (String)entry.getKey(), (String)entry.getValue());
        }
        return null;
    }

    protected void assignDomain(BindDomainsContext ctx, String record, String zoneId) {
        ChangeBatch changeBatch = new ChangeBatch();
        changeBatch.setComment(String.format("Updated for env %s", ctx.getCurEnv().getCNAME()));
        ResourceRecordSet resourceRecordSet = null;
        ListResourceRecordSetsResult listResourceRecordSets = this.r53.listResourceRecordSets(new ListResourceRecordSetsRequest(zoneId));
        for (ResourceRecordSet rrs : listResourceRecordSets.getResourceRecordSets()) {
            boolean matchesTypes;
            if (!rrs.getName().equals(record) || !(matchesTypes = "A".equals(rrs.getType()) || "CNAME".equals(rrs.getType()))) continue;
            if (this.isInfoEnabled()) {
                this.info("Excluding resourceRecordSet %s for domain %s", rrs, record);
            }
            changeBatch.getChanges().add(new Change(ChangeAction.DELETE, rrs));
        }
        resourceRecordSet = new ResourceRecordSet();
        resourceRecordSet.setName(record);
        resourceRecordSet.setType(RRType.A);
        if (ctx.singleInstance) {
            String address = ctx.getCurEnv().getEndpointURL();
            ResourceRecord resourceRecord = new ResourceRecord(address);
            resourceRecordSet.setTTL(Long.valueOf(60L));
            resourceRecordSet.setResourceRecords(Arrays.asList(resourceRecord));
            if (this.isInfoEnabled()) {
                this.info("Adding resourceRecordSet %s for domain %s mapped to %s", resourceRecordSet, record, address);
            }
        } else {
            AliasTarget aliasTarget = new AliasTarget();
            aliasTarget.setHostedZoneId(ctx.getElbHostedZoneId());
            aliasTarget.setDNSName(ctx.getCurEnv().getEndpointURL());
            resourceRecordSet.setAliasTarget(aliasTarget);
            if (this.isInfoEnabled()) {
                this.info("Adding resourceRecordSet %s for domain %s mapped to %s", resourceRecordSet, record, aliasTarget.getDNSName());
            }
        }
        changeBatch.getChanges().add(new Change(ChangeAction.CREATE, resourceRecordSet));
        if (this.isInfoEnabled()) {
            this.info("Changes to be sent: %s", changeBatch.getChanges());
        }
        ChangeResourceRecordSetsRequest req = new ChangeResourceRecordSetsRequest(zoneId, changeBatch);
        this.r53.changeResourceRecordSets(req);
    }

    String formatDomain(String d) {
        return StringUtils.strip((String)d, (String)".").concat(".");
    }
}

