/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.beanstalk.cmd.env.create;

import br.com.ingenieux.mojo.aws.util.CredentialsUtil;
import br.com.ingenieux.mojo.beanstalk.AbstractBeanstalkMojo;
import br.com.ingenieux.mojo.beanstalk.cmd.BaseCommand;
import br.com.ingenieux.mojo.beanstalk.cmd.env.create.CreateEnvironmentContext;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentRequest;
import com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentResult;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentTier;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojoExecutionException;

public class CreateEnvironmentCommand
extends BaseCommand<CreateEnvironmentContext, CreateEnvironmentResult> {
    public CreateEnvironmentCommand(AbstractBeanstalkMojo parentMojo) throws AbstractMojoExecutionException {
        super(parentMojo);
    }

    @Override
    protected CreateEnvironmentResult executeInternal(CreateEnvironmentContext context) throws Exception {
        CreateEnvironmentRequest request = new CreateEnvironmentRequest();
        request.setApplicationName(context.getApplicationName());
        request.setCNAMEPrefix(this.parentMojo.ensureSuffixStripped(context.getCnamePrefix()));
        request.setDescription(context.getApplicationDescription());
        request.setEnvironmentName(context.getEnvironmentName());
        request.setTags(context.getTags());
        request.setOptionSettings(Arrays.asList(context.getOptionSettings()));
        if ("Worker".equals(context.getEnvironmentTierName())) {
            if (this.contextDoesNotContainsEC2Role(context)) {
                this.parentMojo.getLog().warn((CharSequence)"It is meaningless to launch a worker without an IAM Role. If you set in templateName, thats fine, but here's a warning for you");
            }
            context.setEnvironmentTierType("SQS/HTTP");
            request.setCNAMEPrefix(null);
            request.setTier(new EnvironmentTier().withName(context.getEnvironmentTierName()).withType(context.getEnvironmentTierType()).withVersion(context.getEnvironmentTierVersion()));
        }
        if (StringUtils.isNotBlank((String)context.getTemplateName())) {
            request.setTemplateName(this.parentMojo.lookupTemplateName(context.getApplicationName(), context.getTemplateName()));
        } else if (StringUtils.isNotBlank((String)context.getSolutionStack())) {
            request.setSolutionStackName(context.getSolutionStack());
        }
        request.setVersionLabel(context.getVersionLabel());
        if (this.parentMojo.isVerbose()) {
            this.parentMojo.getLog().info((CharSequence)("Requesting createEnvironment w/ request: " + CredentialsUtil.redact((String)("" + request))));
        }
        return this.service.createEnvironment(request);
    }

    protected boolean contextDoesNotContainsEC2Role(CreateEnvironmentContext context) {
        boolean found = false;
        for (ConfigurationOptionSetting opt : context.getOptionSettings()) {
            boolean bl = found = opt.getOptionName().equals("IamInstanceProfile") && opt.getNamespace().equals("aws:autoscaling:launchconfiguration");
            if (found) break;
        }
        return !found;
    }
}

