/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.beanstalk.cmd.env.update;

import br.com.ingenieux.mojo.beanstalk.AbstractBeanstalkMojo;
import br.com.ingenieux.mojo.beanstalk.cmd.BaseCommand;
import br.com.ingenieux.mojo.beanstalk.cmd.env.update.UpdateEnvironmentContext;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentTier;
import com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentRequest;
import com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentResult;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojoExecutionException;

public class UpdateEnvironmentCommand
extends BaseCommand<UpdateEnvironmentContext, UpdateEnvironmentResult> {
    public UpdateEnvironmentCommand(AbstractBeanstalkMojo parentMojo) throws AbstractMojoExecutionException {
        super(parentMojo);
    }

    @Override
    protected UpdateEnvironmentResult executeInternal(UpdateEnvironmentContext context) throws Exception {
        UpdateEnvironmentRequest req = new UpdateEnvironmentRequest();
        if (null != context.environmentDescription) {
            req.setDescription(context.environmentDescription);
        }
        if (null != context.environmentName) {
            req.setEnvironmentName(context.environmentName);
        } else if (null != context.environmentId) {
            req.setEnvironmentId(context.environmentId);
        }
        if (null != context.getEnvironmentTierName()) {
            String envTierType = "Standard";
            String envTierVersion = "1.0";
            if ("Worker".equals(context.getEnvironmentTierName())) {
                envTierType = "SQS/JSON";
            }
            req.setTier(new EnvironmentTier().withName(context.getEnvironmentTierName()).withType(envTierType).withVersion(envTierVersion));
        }
        if (null != context.optionSettings && 0 != context.optionSettings.length) {
            req.setOptionSettings(Arrays.asList(context.optionSettings));
        }
        if (StringUtils.isNotBlank((String)context.versionLabel)) {
            this.info("Calling update-environment, and using versionLabel: " + context.versionLabel, new Object[0]);
            req.setVersionLabel(context.versionLabel);
        } else if (StringUtils.isNotBlank((String)context.templateName)) {
            this.info("Calling update-environment, and using templateName: " + context.templateName, new Object[0]);
            req.setTemplateName(context.templateName);
        }
        return this.service.updateEnvironment(req);
    }
}

