/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.beanstalk.cmd.env.waitfor;

import br.com.ingenieux.mojo.beanstalk.AbstractBeanstalkMojo;
import br.com.ingenieux.mojo.beanstalk.cmd.BaseCommand;
import br.com.ingenieux.mojo.beanstalk.cmd.env.waitfor.WaitForEnvironmentContext;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEventsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEventsResult;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentDescription;
import com.amazonaws.services.elasticbeanstalk.model.EventDescription;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.maven.plugin.MojoExecutionException;

public class WaitForEnvironmentCommand
extends BaseCommand<WaitForEnvironmentContext, EnvironmentDescription> {
    public static final long POLL_INTERVAL = 30000L;
    private static final long MINS_TO_MSEC = 60000L;

    public WaitForEnvironmentCommand(AbstractBeanstalkMojo parentMojo) throws MojoExecutionException {
        super(parentMojo);
    }

    public Collection<EnvironmentDescription> lookupInternal(WaitForEnvironmentContext context) {
        List<Predicate<EnvironmentDescription>> envPredicates = this.getEnvironmentDescriptionPredicate(context);
        DescribeEnvironmentsRequest req = new DescribeEnvironmentsRequest().withApplicationName(context.getApplicationName()).withIncludeDeleted(Boolean.valueOf(true));
        List envs = this.parentMojo.getService().describeEnvironments(req).getEnvironments();
        return Collections2.filter((Collection)envs, (Predicate)Predicates.and(envPredicates));
    }

    protected List<Predicate<EnvironmentDescription>> getEnvironmentDescriptionPredicate(WaitForEnvironmentContext context) {
        final String environmentRef = context.getEnvironmentRef();
        String statusToWaitFor = StringUtils.defaultString((String)context.getStatusToWaitFor(), (String)"!Terminated");
        final String healthToWaitFor = context.getHealth();
        Validate.isTrue((boolean)StringUtils.isNotBlank((String)environmentRef), (String)"EnvironmentRef is blank or null", (Object)environmentRef);
        final boolean negated = statusToWaitFor.startsWith("!");
        ArrayList<Predicate<EnvironmentDescription>> result = new ArrayList<Predicate<EnvironmentDescription>>();
        if (environmentRef.matches("e-\\p{Alnum}{10}")) {
            result.add(new Predicate<EnvironmentDescription>(){

                public boolean apply(EnvironmentDescription t) {
                    return t.getEnvironmentId().equals(environmentRef);
                }
            });
            this.info("... with environmentId equal to '%s'", environmentRef);
        } else if (environmentRef.matches(".*\\Q.elasticbeanstalk.com\\E")) {
            result.add(new Predicate<EnvironmentDescription>(){

                public boolean apply(EnvironmentDescription t) {
                    return StringUtils.defaultString((String)t.getCNAME()).equals(environmentRef);
                }
            });
            this.info("... with cname set to '%s'", environmentRef);
        } else {
            String tmpRE = Pattern.quote(environmentRef);
            if (environmentRef.endsWith("*")) {
                tmpRE = String.format("^\\Q%s\\E.*", environmentRef.substring(0, -1 + environmentRef.length()));
            }
            final String environmentRefNameRE = tmpRE;
            result.add(new Predicate<EnvironmentDescription>(){

                public boolean apply(EnvironmentDescription t) {
                    return t.getEnvironmentName().matches(environmentRefNameRE);
                }
            });
            this.info("... with environmentName matching re '%s'", environmentRefNameRE);
        }
        final int offset = negated ? 1 : 0;
        final String vStatusToWaitFor = statusToWaitFor.substring(offset);
        result.add(new Predicate<EnvironmentDescription>(){

            public boolean apply(EnvironmentDescription t) {
                boolean result = vStatusToWaitFor.equals(t.getStatus());
                if (negated) {
                    result = !result;
                }
                WaitForEnvironmentCommand.this.debug("testing status '%s' as equal as '%s' (negated? %s, offset: %d): %s", vStatusToWaitFor, t.getStatus(), negated, offset, result);
                return result;
            }
        });
        this.info("... with status %s set to '%s'", negated ? "*NOT*" : " ", vStatusToWaitFor);
        if (StringUtils.isNotBlank((String)healthToWaitFor)) {
            result.add(new Predicate<EnvironmentDescription>(){

                public boolean apply(EnvironmentDescription t) {
                    return t.getHealth().equals(healthToWaitFor);
                }
            });
            this.info("... with health equal to '%s'", healthToWaitFor);
        }
        return result;
    }

    @Override
    public EnvironmentDescription executeInternal(WaitForEnvironmentContext context) throws Exception {
        long timeoutMins = context.getTimeoutMins().intValue();
        Date expiresAt = new Date(System.currentTimeMillis() + 60000L * timeoutMins);
        Date lastMessageRecord = new Date();
        this.info("Environment Lookup", new Object[0]);
        List<Predicate<EnvironmentDescription>> envPredicates = this.getEnvironmentDescriptionPredicate(context);
        Predicate<EnvironmentDescription> corePredicate = envPredicates.get(0);
        Predicate fullPredicate = Predicates.and(envPredicates);
        do {
            DescribeEnvironmentsRequest req = new DescribeEnvironmentsRequest().withApplicationName(context.getApplicationName()).withIncludeDeleted(Boolean.valueOf(true));
            List envs = this.parentMojo.getService().describeEnvironments(req).getEnvironments();
            Collection validEnvironments = Collections2.filter((Collection)envs, (Predicate)fullPredicate);
            this.debug("There are %d environments", validEnvironments.size());
            if (1 == validEnvironments.size()) {
                EnvironmentDescription foundEnvironment = (EnvironmentDescription)validEnvironments.iterator().next();
                this.debug("Found environment %s", foundEnvironment);
                return foundEnvironment;
            }
            this.debug("Found %d environments. No good. Ignoring.", validEnvironments.size());
            for (EnvironmentDescription d : validEnvironments) {
                this.debug(" ... %s", d);
            }
            Collection foundEnvironments = Collections2.filter((Collection)envs, corePredicate);
            if (1 == foundEnvironments.size()) {
                EnvironmentDescription foundEnvironment = (EnvironmentDescription)foundEnvironments.iterator().next();
                DescribeEventsResult events = this.service.describeEvents(new DescribeEventsRequest().withApplicationName(foundEnvironment.getApplicationName()).withStartTime(new Date(1000L + lastMessageRecord.getTime())).withEnvironmentId(foundEnvironment.getEnvironmentId()).withSeverity("TRACE"));
                TreeSet<EventDescription> eventList = new TreeSet<EventDescription>(new EventDescriptionComparator());
                eventList.addAll(events.getEvents());
                for (EventDescription d : eventList) {
                    this.info(String.format("%s %s %s", d.getSeverity(), d.getEventDate(), d.getMessage()), new Object[0]);
                    if (d.getSeverity().equals("ERROR")) {
                        throw new MojoExecutionException("Something went wrong in while waiting for the environment setup to complete : " + d.getMessage());
                    }
                    lastMessageRecord = d.getEventDate();
                }
            }
            this.sleepInterval(30000L);
        } while (!this.timedOutP(expiresAt));
        throw new MojoExecutionException("Timed out");
    }

    boolean timedOutP(Date expiresAt) throws MojoExecutionException {
        return expiresAt.before(new Date(System.currentTimeMillis()));
    }

    public void sleepInterval(long pollInterval) {
        this.debug("Sleeping for %d seconds", pollInterval / 1000L);
        try {
            Thread.sleep(pollInterval);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static class EventDescriptionComparator
    implements Comparator<EventDescription> {
        EventDescriptionComparator() {
        }

        @Override
        public int compare(EventDescription o1, EventDescription o2) {
            return o1.getEventDate().compareTo(o2.getEventDate());
        }
    }
}

