/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.beanstalk.config;

import br.com.ingenieux.mojo.beanstalk.AbstractBeanstalkMojo;
import br.com.ingenieux.mojo.beanstalk.ConfigurationTemplate;
import com.amazonaws.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest;
import com.amazonaws.services.elasticbeanstalk.model.CreateConfigurationTemplateResult;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="create-configuration-templates")
public class CreateConfigurationTemplateMojo
extends AbstractBeanstalkMojo {
    @Parameter(property="beanstalk.applicationName", defaultValue="${project.artifactId}", required=true)
    String applicationName;
    @Parameter(property="beanstalk.configurationTemplate")
    String configurationTemplate;
    @Parameter
    ConfigurationTemplate[] configurationTemplates;

    protected Object executeInternal() throws MojoExecutionException, MojoFailureException {
        boolean bConfigurationTemplateDefined = StringUtils.isNotBlank((String)this.configurationTemplate);
        if (bConfigurationTemplateDefined) {
            return this.createConfiguration(this.configurationTemplate);
        }
        for (ConfigurationTemplate template : this.configurationTemplates) {
            this.createConfiguration(template.getId());
        }
        return null;
    }

    CreateConfigurationTemplateResult createConfiguration(String templateName) throws MojoFailureException {
        ConfigurationTemplate template = this.getConfigurationTemplate(templateName);
        if (null == template) {
            throw new MojoFailureException(String.format("templateName ('%s') not found", templateName));
        }
        if (StringUtils.isBlank((String)template.getSolutionStack())) {
            throw new MojoFailureException(String.format("Please define solutionStack/ in template %s", templateName));
        }
        CreateConfigurationTemplateRequest req = new CreateConfigurationTemplateRequest(this.applicationName, templateName);
        req.setSolutionStackName(template.getSolutionStack());
        req.setOptionSettings(Arrays.asList(template.getOptionSettings()));
        return this.getService().createConfigurationTemplate(req);
    }

    private ConfigurationTemplate getConfigurationTemplate(String id) {
        for (ConfigurationTemplate template : this.configurationTemplates) {
            if (!id.equals(template.getId())) continue;
            return template;
        }
        return null;
    }
}

