/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.beanstalk.config;

import br.com.ingenieux.mojo.beanstalk.AbstractBeanstalkMojo;
import br.com.ingenieux.mojo.beanstalk.ConfigurationTemplate;
import com.amazonaws.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="delete-configuration-template")
public class DeleteConfigurationTemplateMojo
extends AbstractBeanstalkMojo {
    @Parameter(property="beanstalk.applicationName", defaultValue="${project.artifactId}", required=true)
    String applicationName;
    @Parameter(property="beanstalk.configurationTemplate")
    String configurationTemplate;
    @Parameter
    ConfigurationTemplate[] configurationTemplates;

    protected Object executeInternal() throws MojoExecutionException, MojoFailureException {
        boolean bConfigurationTemplateDefined = StringUtils.isNotBlank((String)this.configurationTemplate);
        if (bConfigurationTemplateDefined) {
            this.deleteConfiguration(this.configurationTemplate);
        } else {
            for (ConfigurationTemplate template : this.configurationTemplates) {
                this.deleteConfiguration(template.getId());
            }
        }
        return null;
    }

    void deleteConfiguration(String templateName) {
        DeleteConfigurationTemplateRequest req = new DeleteConfigurationTemplateRequest(this.applicationName, templateName);
        this.getService().deleteConfigurationTemplate(req);
    }
}

