/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.beanstalk.config;

import br.com.ingenieux.mojo.beanstalk.AbstractNeedsEnvironmentMojo;
import com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentDescription;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="describe-configuration-settings")
public class DescribeConfigurationSettingsMojo
extends AbstractNeedsEnvironmentMojo {
    @Parameter(property="beanstalk.templateName")
    String templateName;

    @Override
    protected EnvironmentDescription handleResults(Collection<EnvironmentDescription> environments) throws MojoExecutionException {
        try {
            return super.handleResults(environments);
        }
        catch (Exception exc) {
            return null;
        }
    }

    protected Object executeInternal() throws MojoExecutionException, MojoFailureException {
        boolean bTemplateNameDefined = StringUtils.isNotBlank((String)this.templateName) && !this.hasWildcards(this.templateName);
        DescribeConfigurationSettingsRequest req = new DescribeConfigurationSettingsRequest().withApplicationName(this.applicationName);
        if (bTemplateNameDefined) {
            req.withTemplateName(this.templateName);
        } else if (null != this.curEnv) {
            req.withEnvironmentName(this.curEnv.getEnvironmentName());
        } else {
            this.getLog().warn((CharSequence)"You must supply a templateName or environmentName. Ignoring");
            return null;
        }
        this.getLog().info((CharSequence)("Request: " + req));
        return this.getService().describeConfigurationSettings(req);
    }
}

