/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.beanstalk.config;

import br.com.ingenieux.mojo.beanstalk.AbstractBeanstalkMojo;
import com.amazonaws.services.elasticbeanstalk.model.ApplicationDescription;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationSettingsDescription;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationSettingsResult;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="describe-configuration-templates")
public class DescribeConfigurationTemplatesMojo
extends AbstractBeanstalkMojo {
    private static final String ENDL = System.getProperty("line.separator");
    @Parameter(property="beanstalk.applicationName", defaultValue="${project.artifactId}", required=true)
    protected String applicationName;
    @Parameter(property="beanstalk.configurationTemplate")
    String configurationTemplate;
    @Parameter(property="beanstalk.outputFile")
    File outputFile;

    protected Object executeInternal() throws Exception {
        DescribeApplicationsRequest req = new DescribeApplicationsRequest().withApplicationNames(new String[]{this.applicationName});
        boolean bConfigurationTemplateDefined = StringUtils.isNotBlank((String)this.configurationTemplate);
        DescribeApplicationsResult apps = this.getService().describeApplications(req);
        List applications = apps.getApplications();
        if (applications.isEmpty()) {
            String errorMessage = "Application ('" + this.applicationName + "') not found!";
            this.getLog().warn((CharSequence)errorMessage);
            throw new MojoFailureException(errorMessage);
        }
        ApplicationDescription desc = (ApplicationDescription)applications.get(0);
        List configTemplates = desc.getConfigurationTemplates();
        if (bConfigurationTemplateDefined) {
            this.describeConfigurationTemplate(this.configurationTemplate);
        } else {
            for (String availConfigTemplate : configTemplates) {
                this.describeConfigurationTemplate(availConfigTemplate);
            }
        }
        return null;
    }

    void describeConfigurationTemplate(String configTemplateName) throws Exception {
        block8: {
            ArrayList<String> buf;
            block7: {
                DescribeConfigurationSettingsRequest req = new DescribeConfigurationSettingsRequest().withApplicationName(this.applicationName).withTemplateName(configTemplateName);
                DescribeConfigurationSettingsResult configSettings = this.getService().describeConfigurationSettings(req);
                buf = new ArrayList<String>();
                buf.add("<optionSettings>");
                for (ConfigurationSettingsDescription configSetting : configSettings.getConfigurationSettings()) {
                    for (ConfigurationOptionSetting setting : configSetting.getOptionSettings()) {
                        if (this.harmfulOptionSettingP(null, setting)) continue;
                        buf.add("  <optionSetting>");
                        buf.add(String.format("    <%s>%s</%1$s>", "namespace", setting.getNamespace()));
                        buf.add(String.format("    <%s>%s</%1$s>", "optionName", setting.getOptionName()));
                        buf.add(String.format("    <%s>%s</%1$s>", "value", setting.getValue()));
                        buf.add("  </optionSetting>");
                    }
                }
                buf.add("</optionSettings>");
                if (null == this.outputFile) break block7;
                this.getLog().info((CharSequence)("Dumping results to file: " + this.outputFile.getName()));
                String bufChars = StringUtils.join(buf.iterator(), (String)ENDL);
                FileWriter writer = null;
                try {
                    writer = new FileWriter(this.outputFile);
                    IOUtils.copy((Reader)new StringReader(bufChars), (Writer)writer);
                }
                catch (IOException e) {
                    try {
                        throw new RuntimeException("Failure when writing to file: " + this.outputFile.getName(), e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(writer);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Writer)writer);
                break block8;
            }
            this.getLog().info((CharSequence)"Dumping results to stdout");
            for (String e : buf) {
                this.getLog().info((CharSequence)e);
            }
        }
    }
}

