/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.beanstalk.config;

import br.com.ingenieux.mojo.beanstalk.AbstractBeanstalkMojo;
import com.amazonaws.services.elasticbeanstalk.model.ApplicationDescription;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsResult;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="list-configuration-templates", requiresDirectInvocation=true)
public class ListConfigurationTemplatesMojo
extends AbstractBeanstalkMojo {
    @Parameter(property="beanstalk.applicationName", defaultValue="${project.artifactId}", required=true)
    protected String applicationName;

    protected Object executeInternal() throws MojoExecutionException, MojoFailureException {
        DescribeApplicationsRequest req = new DescribeApplicationsRequest().withApplicationNames(new String[]{this.applicationName});
        DescribeApplicationsResult apps = this.getService().describeApplications(req);
        List applications = apps.getApplications();
        if (applications.isEmpty()) {
            String errorMessage = "Application ('" + this.applicationName + "') not found!";
            this.getLog().warn((CharSequence)errorMessage);
            throw new MojoFailureException(errorMessage);
        }
        ApplicationDescription desc = (ApplicationDescription)applications.get(0);
        List configTemplates = desc.getConfigurationTemplates();
        this.getLog().info((CharSequence)String.format("There are %d config templates", configTemplates.size()));
        return configTemplates;
    }
}

