/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.beanstalk.config;

import br.com.ingenieux.mojo.beanstalk.AbstractBeanstalkMojo;
import br.com.ingenieux.mojo.beanstalk.ConfigurationTemplate;
import com.amazonaws.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest;
import com.amazonaws.services.elasticbeanstalk.model.UpdateConfigurationTemplateResult;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="update-configuration-templates")
public class UpdateConfigurationTemplateMojo
extends AbstractBeanstalkMojo {
    @Parameter(property="beanstalk.applicationName", defaultValue="${project.artifactId}", required=true)
    String applicationName;
    @Parameter(property="beanstalk.configurationTemplate")
    String configurationTemplate;
    @Parameter
    ConfigurationTemplate[] configurationTemplates;

    protected Object executeInternal() throws MojoExecutionException, MojoFailureException {
        boolean bConfigurationTemplateDefined = StringUtils.isNotBlank((String)this.configurationTemplate);
        if (bConfigurationTemplateDefined) {
            return this.updateConfiguration(this.configurationTemplate);
        }
        for (ConfigurationTemplate template : this.configurationTemplates) {
            this.updateConfiguration(template.getId());
        }
        return null;
    }

    UpdateConfigurationTemplateResult updateConfiguration(String templateName) throws MojoFailureException {
        ConfigurationTemplate template = this.getConfigurationTemplate(templateName);
        if (null == template) {
            throw new MojoFailureException(String.format("templateName ('%s') not found", templateName));
        }
        if (StringUtils.isBlank((String)template.getSolutionStack())) {
            throw new MojoFailureException(String.format("Please define solutionStack/ in template %s", templateName));
        }
        UpdateConfigurationTemplateRequest req = new UpdateConfigurationTemplateRequest(this.applicationName, templateName);
        req.setOptionSettings(Arrays.asList(template.getOptionSettings()));
        return this.getService().updateConfigurationTemplate(req);
    }

    private ConfigurationTemplate getConfigurationTemplate(String id) {
        for (ConfigurationTemplate template : this.configurationTemplates) {
            if (!id.equals(template.getId())) continue;
            return template;
        }
        return null;
    }
}

