/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.beanstalk.env;

import br.com.ingenieux.mojo.beanstalk.AbstractNeedsEnvironmentMojo;
import br.com.ingenieux.mojo.beanstalk.cmd.env.create.CreateEnvironmentCommand;
import br.com.ingenieux.mojo.beanstalk.cmd.env.create.CreateEnvironmentContext;
import br.com.ingenieux.mojo.beanstalk.cmd.env.create.CreateEnvironmentContextBuilder;
import br.com.ingenieux.mojo.beanstalk.cmd.env.waitfor.WaitForEnvironmentCommand;
import br.com.ingenieux.mojo.beanstalk.cmd.env.waitfor.WaitForEnvironmentContext;
import br.com.ingenieux.mojo.beanstalk.cmd.env.waitfor.WaitForEnvironmentContextBuilder;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentResult;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.maven.plugin.AbstractMojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="create-environment")
public class CreateEnvironmentMojo
extends AbstractNeedsEnvironmentMojo {
    public static final String BEANSTALK_TAG = "beanstalk.tag.";
    @Parameter(property="beanstalk.environmentName", required=true)
    protected String environmentName;
    @Parameter(property="beanstalk.applicationDescription", defaultValue="${project.name}")
    String applicationDescription;
    @Parameter
    ConfigurationOptionSetting[] optionSettings;
    @Parameter(property="beanstalk.versionLabel")
    String versionLabel;
    @Parameter(property="beanstalk.solutionStack", defaultValue="32bit Amazon Linux running Tomcat 7")
    String solutionStack;
    @Parameter(property="beanstalk.templateName")
    String templateName;
    @Parameter(property="beanstalk.waitForReady", defaultValue="true")
    boolean waitForReady;
    @Parameter(property="beanstalk.environmentTierName", defaultValue="WebServer")
    String environmentTierName;
    @Parameter(property="beanstalk.cnamePrefix")
    String cnamePrefix;
    @Parameter
    Map<String, String> beanstalkTags;

    @Override
    protected void configure() {
    }

    protected Object executeInternal() throws Exception {
        this.versionLabel = this.lookupVersionLabel(this.applicationName, this.versionLabel);
        return this.createEnvironment(this.cnamePrefix, this.environmentName);
    }

    protected CreateEnvironmentResult createEnvironment(String cnameToCreate, String newEnvironmentName) throws AbstractMojoExecutionException {
        Validate.isTrue((boolean)StringUtils.isNotBlank((String)newEnvironmentName), (String)"No New Environment Name Supplied");
        if (null == this.optionSettings) {
            this.optionSettings = this.introspectOptionSettings();
        }
        if (this.beanstalkTags == null) {
            this.beanstalkTags = this.introspectEnvironmentTags();
        }
        this.versionLabel = this.lookupVersionLabel(this.applicationName, this.versionLabel);
        CreateEnvironmentContextBuilder builder = (CreateEnvironmentContextBuilder)((CreateEnvironmentContextBuilder)((CreateEnvironmentContextBuilder)((CreateEnvironmentContextBuilder)((CreateEnvironmentContextBuilder)((CreateEnvironmentContextBuilder)((CreateEnvironmentContextBuilder)((CreateEnvironmentContextBuilder)((CreateEnvironmentContextBuilder)((CreateEnvironmentContextBuilder)CreateEnvironmentContextBuilder.createEnvironmentContext().withApplicationName(this.applicationName)).withApplicationDescription(this.applicationDescription)).withCnamePrefix(cnameToCreate)).withSolutionStack(this.lookupSolutionStack(this.solutionStack))).withTemplateName(this.templateName)).withEnvironmentName(newEnvironmentName)).withOptionSettings(this.optionSettings)).withEnvironmentTierName(this.environmentTierName)).withVersionLabel(this.versionLabel)).withTags(this.beanstalkTags);
        CreateEnvironmentContext context = builder.build();
        CreateEnvironmentCommand command = new CreateEnvironmentCommand(this);
        CreateEnvironmentResult result = (CreateEnvironmentResult)command.execute(context);
        if (this.waitForReady) {
            WaitForEnvironmentContext ctx = ((WaitForEnvironmentContextBuilder)((WaitForEnvironmentContextBuilder)((WaitForEnvironmentContextBuilder)((WaitForEnvironmentContextBuilder)new WaitForEnvironmentContextBuilder().withEnvironmentRef(result.getEnvironmentId())).withApplicationName(result.getApplicationName())).withHealth("Green")).withStatusToWaitFor("Ready")).build();
            new WaitForEnvironmentCommand(this).execute(ctx);
        }
        return result;
    }

    private Map<String, String> introspectEnvironmentTags() {
        Map<String, String> tags = CreateEnvironmentMojo.extractTagsFromProperties(this.project.getProperties());
        tags.putAll(CreateEnvironmentMojo.extractTagsFromProperties(System.getProperties()));
        return tags;
    }

    private static Map<String, String> extractTagsFromProperties(Properties systemProperties) {
        HashMap<String, String> tags = new HashMap<String, String>();
        for (String propertyName : systemProperties.stringPropertyNames()) {
            if (!propertyName.startsWith(BEANSTALK_TAG)) continue;
            tags.put(propertyName.substring(BEANSTALK_TAG.length()), systemProperties.getProperty(propertyName));
        }
        return tags;
    }
}

