/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.beanstalk.env;

import br.com.ingenieux.mojo.beanstalk.AbstractBeanstalkMojo;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsResult;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="describe-environments", requiresDirectInvocation=true)
public class DescribeEnvironmentsMojo
extends AbstractBeanstalkMojo {
    @Parameter(property="beanstalk.applicationName", defaultValue="${project.artifactId}", required=true)
    protected String applicationName;
    @Parameter(property="beanstalk.includeDeleted")
    boolean includeDeleted;
    @Parameter(property="beanstalk.outputFile")
    File outputFile;

    protected Object executeInternal() throws MojoExecutionException, MojoFailureException {
        DescribeEnvironmentsRequest req = new DescribeEnvironmentsRequest();
        req.setApplicationName(this.applicationName);
        req.setIncludeDeleted(Boolean.valueOf(this.includeDeleted));
        DescribeEnvironmentsResult result = this.getService().describeEnvironments(req);
        if (null != this.outputFile) {
            this.getLog().info((CharSequence)("Writing results into " + this.outputFile.getName()));
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                ObjectWriter writer = objectMapper.writerWithDefaultPrettyPrinter();
                writer.writeValue(this.outputFile, (Object)result.getEnvironments());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return null;
        }
        return result;
    }
}

