/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.beanstalk.env;

import br.com.ingenieux.mojo.beanstalk.AbstractNeedsEnvironmentMojo;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionDescription;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationSettingsDescription;
import com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationOptionsResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationSettingsResult;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="dump-environment-settings", requiresDirectInvocation=true)
public class DumpEnvironmentSettings
extends AbstractNeedsEnvironmentMojo {
    @Parameter(property="beanstalk.outputFile")
    private File outputFile;
    @Parameter(property="beanstalk.outputFileFormat", defaultValue="properties")
    private String outputFileFormat;
    @Parameter(property="beanstalk.changedOnly", defaultValue="true")
    private boolean changedOnly;
    private Map<String, ConfigurationOptionDescription> defaultSettings = new TreeMap<String, ConfigurationOptionDescription>();

    protected Object executeInternal() throws Exception {
        DescribeConfigurationOptionsResult configOptions = this.getService().describeConfigurationOptions(new DescribeConfigurationOptionsRequest().withApplicationName(this.applicationName).withEnvironmentName(this.curEnv.getEnvironmentName()));
        for (ConfigurationOptionDescription o : configOptions.getOptions()) {
            String key = String.format("beanstalk.env.%s.%s", o.getNamespace().replace(":", "."), o.getName());
            for (Map.Entry entry : COMMON_PARAMETERS.entrySet()) {
                ConfigurationOptionSetting cos = (ConfigurationOptionSetting)entry.getValue();
                if (!cos.getNamespace().equals(o.getNamespace()) || !cos.getOptionName().equals(o.getName())) continue;
                key = (String)entry.getKey();
                break;
            }
            this.defaultSettings.put(key, o);
        }
        DescribeConfigurationSettingsResult configurationSettings = this.getService().describeConfigurationSettings(new DescribeConfigurationSettingsRequest().withApplicationName(this.applicationName).withEnvironmentName(this.curEnv.getEnvironmentName()));
        Properties newProperties = new Properties();
        if (configurationSettings.getConfigurationSettings().isEmpty()) {
            throw new IllegalStateException("No Configuration Settings received");
        }
        ConfigurationSettingsDescription configSettings = (ConfigurationSettingsDescription)configurationSettings.getConfigurationSettings().get(0);
        LinkedHashMap<String, ConfigurationOptionSetting> keyMap = new LinkedHashMap<String, ConfigurationOptionSetting>();
        for (ConfigurationOptionSetting d : configSettings.getOptionSettings()) {
            String value;
            String key = String.format("beanstalk.env.%s.%s", d.getNamespace().replaceAll(":", "."), d.getOptionName());
            String defaultValue = "";
            String outputKey = key;
            keyMap.put(key, d);
            for (Map.Entry cosEntry : COMMON_PARAMETERS.entrySet()) {
                ConfigurationOptionSetting v = (ConfigurationOptionSetting)cosEntry.getValue();
                boolean match = v.getNamespace().equals(d.getNamespace()) && v.getOptionName().equals(d.getOptionName());
                if (!match) continue;
                outputKey = (String)cosEntry.getKey();
                break;
            }
            if (this.defaultSettings.containsKey(outputKey)) {
                defaultValue = StringUtils.defaultString((String)this.defaultSettings.get(outputKey).getDefaultValue());
            }
            if (null == (value = d.getValue()) || StringUtils.isBlank((String)("" + value))) continue;
            if (!defaultValue.equals(value)) {
                if (!value.contains(this.curEnv.getEnvironmentId())) {
                    this.getLog().info((CharSequence)("Adding property " + key));
                    if (this.changedOnly) {
                        String curValue = this.project.getProperties().getProperty(outputKey);
                        if (value.equals(curValue)) continue;
                        newProperties.put(outputKey, value);
                        continue;
                    }
                    newProperties.put(outputKey, value);
                    continue;
                }
                this.getLog().info((CharSequence)("Ignoring property " + outputKey + "(value=" + value + ") due to containing references to the environment id"));
                continue;
            }
            this.getLog().debug((CharSequence)("Ignoring property " + key + " (defaulted)"));
        }
        if ("properties".equals(this.outputFileFormat)) {
            String comment = "elastic beanstalk environment properties for " + this.curEnv.getEnvironmentName();
            if (null != this.outputFile) {
                newProperties.store(new FileOutputStream(this.outputFile), comment);
            } else {
                newProperties.store(System.out, comment);
            }
        } else if ("yaml".equals(this.outputFileFormat)) {
            PrintStream printStream = System.out;
            if (null != this.outputFile) {
                printStream = new PrintStream(this.outputFile);
            }
            printStream.println("option_settings:");
            for (Map.Entry<Object, Object> e : newProperties.entrySet()) {
                ConfigurationOptionSetting c = (ConfigurationOptionSetting)keyMap.get("" + e.getKey());
                String value = "" + e.getValue();
                printStream.println("  - namespace: " + c.getNamespace());
                printStream.println("    option_name: " + c.getOptionName());
                printStream.println("    value: " + value);
            }
            printStream.close();
        }
        return null;
    }
}

