/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.beanstalk.env;

import br.com.ingenieux.mojo.beanstalk.AbstractNeedsEnvironmentMojo;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentResourcesResult;
import com.amazonaws.services.elasticbeanstalk.model.Instance;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="dump-instances", requiresDirectInvocation=true)
public class DumpInstancesMojo
extends AbstractNeedsEnvironmentMojo {
    @Parameter(property="beanstalk.outputFile")
    private File outputFile;
    @Parameter(property="beanstalk.dumpPrivateAddresses", defaultValue="false")
    private boolean dumpPrivateAddresses;

    protected Object executeInternal() throws Exception {
        AmazonEC2 ec2 = (AmazonEC2)this.clientFactory.getService(AmazonEC2Client.class);
        DescribeEnvironmentResourcesResult envResources = this.getService().describeEnvironmentResources(new DescribeEnvironmentResourcesRequest().withEnvironmentId(this.curEnv.getEnvironmentId()).withEnvironmentName(this.curEnv.getEnvironmentName()));
        ArrayList<String> instanceIds = new ArrayList<String>();
        for (Instance i : envResources.getEnvironmentResources().getInstances()) {
            instanceIds.add(i.getId());
        }
        DescribeInstancesResult ec2Instances = ec2.describeInstances(new DescribeInstancesRequest().withInstanceIds(instanceIds));
        PrintStream printStream = null;
        if (null != this.outputFile) {
            printStream = new PrintStream(this.outputFile);
        }
        for (Reservation r : ec2Instances.getReservations()) {
            for (com.amazonaws.services.ec2.model.Instance i : r.getInstances()) {
                String ipAddress = this.dumpPrivateAddresses ? i.getPrivateIpAddress() : StringUtils.defaultString((String)i.getPublicIpAddress(), (String)i.getPrivateDnsName());
                String instanceId = i.getInstanceId();
                if (null != printStream) {
                    printStream.println(ipAddress + " # " + instanceId);
                    continue;
                }
                this.getLog().info((CharSequence)(" * " + instanceId + ": " + ipAddress));
            }
        }
        if (null != printStream) {
            printStream.close();
        }
        return null;
    }
}

