/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.beanstalk.env;

import br.com.ingenieux.mojo.beanstalk.AbstractNeedsEnvironmentMojo;
import com.amazonaws.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest;
import com.amazonaws.services.elasticbeanstalk.model.CreateConfigurationTemplateResult;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="tag-environment", requiresDirectInvocation=true)
public class TagEnvironmentMojo
extends AbstractNeedsEnvironmentMojo {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd");
    @Parameter(property="beanstalk.templateName")
    String templateName;

    protected Object executeInternal() throws AbstractMojoExecutionException {
        TreeSet<String> configTemplates = new TreeSet<String>(super.getConfigurationTemplates(this.applicationName));
        String today = DATE_FORMAT.format(new Date());
        if (StringUtils.isBlank((String)this.templateName)) {
            int i = 1;
            do {
                this.templateName = String.format("%s-%s-%02d", this.curEnv.getEnvironmentName(), today, i++);
            } while (configTemplates.contains(this.templateName));
        }
        CreateConfigurationTemplateResult result = this.getService().createConfigurationTemplate(new CreateConfigurationTemplateRequest().withEnvironmentId(this.curEnv.getEnvironmentId()).withTemplateName(this.templateName).withApplicationName(this.curEnv.getApplicationName()));
        this.getLog().info((CharSequence)("Created config template " + this.templateName + " for environment " + this.curEnv.getEnvironmentId()));
        return result;
    }
}

