/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.beanstalk.env;

import br.com.ingenieux.mojo.beanstalk.AbstractNeedsEnvironmentMojo;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentRequest;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="update-environment-options", requiresDirectInvocation=true)
public class UpdateEnvironmentOptionsMojo
extends AbstractNeedsEnvironmentMojo {
    @Parameter
    ConfigurationOptionSetting[] optionSettings;
    @Parameter(property="beanstalk.environmentDescription", defaultValue="default")
    String environmentDescription;
    @Parameter(property="beanstalk.versionLabel")
    String versionLabel;
    @Parameter(property="beanstalk.templateName")
    String templateName;
    @Parameter(property="beanstalk.whatToSet", defaultValue="versionLabel", required=true)
    WhatToSet whatToSet;

    protected Object executeInternal() throws MojoExecutionException, MojoFailureException {
        UpdateEnvironmentRequest req = new UpdateEnvironmentRequest();
        req.setEnvironmentId(this.curEnv.getEnvironmentId());
        req.setEnvironmentName(this.curEnv.getEnvironmentName());
        if (WhatToSet.versionLabel.equals((Object)this.whatToSet)) {
            req.setVersionLabel(this.versionLabel);
        } else if (WhatToSet.description.equals((Object)this.whatToSet)) {
            req.setDescription(this.environmentDescription);
        } else if (WhatToSet.optionSettings.equals((Object)this.whatToSet)) {
            req.setOptionSettings(this.getOptionSettings(this.optionSettings));
        } else if (WhatToSet.templateName.equals((Object)this.whatToSet)) {
            req.setTemplateName(this.lookupTemplateName(this.applicationName, this.templateName));
        }
        return this.getService().updateEnvironment(req);
    }

    public static enum WhatToSet {
        description,
        optionSettings,
        templateName,
        versionLabel;

    }
}

