/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.beanstalk.sec;

import br.com.ingenieux.mojo.aws.Expose;
import br.com.ingenieux.mojo.beanstalk.AbstractBeanstalkMojo;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="expose-security-credentials", requiresProject=true)
public class ExposeSecurityCredentialsMojo
extends AbstractBeanstalkMojo {
    @Parameter
    Expose[] exposes = new Expose[0];
    @Parameter(defaultValue="${project}")
    MavenProject project;
    BuildContext buildContext;

    protected Object executeInternal() throws MojoExecutionException, MojoFailureException {
        if (0 == this.exposes.length) {
            this.exposes = new Expose[1];
            this.exposes[0] = new Expose();
            this.exposes[0].setServerId(this.serverId);
            this.exposes[0].setAccessKey("aws.accessKey");
            this.exposes[0].setSharedKey("aws.secretKey");
        } else {
            try {
                for (Expose e : this.exposes) {
                    this.assertOrWarn(StringUtils.isNotBlank((String)e.getServerId()), "serverId must be supplied");
                    this.assertOrWarn(StringUtils.isNotBlank((String)e.getAccessKey()), "accessKey must be supplied");
                    this.assertOrWarn(StringUtils.isNotBlank((String)e.getSharedKey()), "sharedKey must be supplied");
                }
            }
            catch (IllegalStateException e) {
                return null;
            }
        }
        for (Expose e : this.exposes) {
            Expose realExpose = null;
            try {
                realExpose = super.exposeSettings(e.getServerId());
            }
            catch (Exception exc) {
                this.getLog().warn((CharSequence)("Failed to Expose Settings from serverId ('" + e.getServerId() + "')"));
                continue;
            }
            this.getLog().info((CharSequence)String.format("Writing Security Settings from serverId ('%s') into properties '%s' (accessKey) and '%s' (secretKey)", e.getServerId(), e.getAccessKey(), e.getSharedKey()));
            this.project.getProperties().put(e.getAccessKey(), realExpose.getAccessKey());
            this.project.getProperties().put(e.getSharedKey(), realExpose.getSharedKey());
        }
        return null;
    }

    private void assertOrWarn(boolean condition, String message) {
        if (condition) {
            return;
        }
        if (null != this.buildContext) {
            this.buildContext.addMessage(this.project.getFile(), 1, 1, message, 1, null);
        } else {
            this.getLog().warn((CharSequence)message);
        }
        throw new IllegalStateException(message);
    }
}

