/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.beanstalk.version;

import br.com.ingenieux.mojo.beanstalk.AbstractBeanstalkMojo;
import com.amazonaws.services.elasticbeanstalk.model.ApplicationVersionDescription;
import com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationVersionRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsResult;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentDescription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Pattern;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="clean-previous-versions")
public class CleanPreviousVersionsMojo
extends AbstractBeanstalkMojo {
    @Parameter(property="beanstalk.applicationName", defaultValue="${project.artifactId}", required=true)
    String applicationName;
    @Parameter(property="beanstalk.deleteSourceBundle", defaultValue="false")
    boolean deleteSourceBundle;
    @Parameter(property="beanstalk.versionsToKeep")
    Integer versionsToKeep;
    @Parameter(property="beanstalk.daysToKeep")
    Integer daysToKeep;
    @Parameter(property="beanstalk.cleanFilter")
    String cleanFilter;
    @Parameter(property="beanstalk.dryRun", defaultValue="true")
    boolean dryRun;
    private int deletedVersionsCount;

    protected Object executeInternal() throws MojoExecutionException, MojoFailureException {
        boolean bDaysToKeepDefined;
        boolean bVersionsToKeepDefined = null != this.versionsToKeep;
        boolean bl = bDaysToKeepDefined = null != this.daysToKeep;
        if (!(bVersionsToKeepDefined ^ bDaysToKeepDefined)) {
            throw new MojoFailureException("Declare either versionsToKeep or daysToKeep, but not both nor none!");
        }
        DescribeApplicationVersionsRequest describeApplicationVersionsRequest = new DescribeApplicationVersionsRequest().withApplicationName(this.applicationName);
        DescribeApplicationVersionsResult appVersions = this.getService().describeApplicationVersions(describeApplicationVersionsRequest);
        DescribeEnvironmentsResult environments = this.getService().describeEnvironments();
        ArrayList<ApplicationVersionDescription> appVersionList = new ArrayList<ApplicationVersionDescription>(appVersions.getApplicationVersions());
        this.deletedVersionsCount = 0;
        for (EnvironmentDescription d : environments.getEnvironments()) {
            boolean bActiveEnvironment = d.getStatus().equals("Running") || d.getStatus().equals("Launching") || d.getStatus().equals("Ready");
            ListIterator appVersionIterator = appVersionList.listIterator();
            while (appVersionIterator.hasNext()) {
                ApplicationVersionDescription appVersion = (ApplicationVersionDescription)appVersionIterator.next();
                boolean bMatchesVersion = appVersion.getVersionLabel().equals(d.getVersionLabel());
                if (!bActiveEnvironment || !bMatchesVersion) continue;
                this.getLog().info((CharSequence)("VersionLabel " + appVersion.getVersionLabel() + " is bound to environment " + d.getEnvironmentName() + " - Skipping it"));
                appVersionIterator.remove();
            }
        }
        this.filterAppVersionListByVersionLabelPattern(appVersionList, this.cleanFilter);
        Collections.sort(appVersionList, new Comparator<ApplicationVersionDescription>(){

            @Override
            public int compare(ApplicationVersionDescription o1, ApplicationVersionDescription o2) {
                return new CompareToBuilder().append((Object)o1.getDateUpdated(), (Object)o2.getDateUpdated()).toComparison();
            }
        });
        if (bDaysToKeepDefined) {
            Date now = new Date();
            for (ApplicationVersionDescription d : appVersionList) {
                boolean shouldDeleteP;
                long delta = now.getTime() - d.getDateUpdated().getTime();
                delta /= 1000L;
                boolean bl2 = shouldDeleteP = (delta /= 86400L) > (long)this.daysToKeep.intValue();
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Version " + d.getVersionLabel() + " was from " + delta + " days ago. Should we delete? " + shouldDeleteP));
                }
                if (!shouldDeleteP) continue;
                this.deleteVersion(d);
            }
        } else {
            while (appVersionList.size() > this.versionsToKeep) {
                this.deleteVersion((ApplicationVersionDescription)appVersionList.remove(0));
            }
        }
        this.getLog().info((CharSequence)("Deleted " + this.deletedVersionsCount + " versions."));
        return null;
    }

    void deleteVersion(ApplicationVersionDescription versionToRemove) {
        this.getLog().info((CharSequence)("Must delete version: " + versionToRemove.getVersionLabel()));
        DeleteApplicationVersionRequest req = new DeleteApplicationVersionRequest().withApplicationName(versionToRemove.getApplicationName()).withDeleteSourceBundle(Boolean.valueOf(this.deleteSourceBundle)).withVersionLabel(versionToRemove.getVersionLabel());
        if (!this.dryRun) {
            this.getService().deleteApplicationVersion(req);
            ++this.deletedVersionsCount;
        }
    }

    void filterAppVersionListByVersionLabelPattern(List<ApplicationVersionDescription> appVersionList, String patternString) {
        if (patternString == null) {
            return;
        }
        this.getLog().info((CharSequence)("Filtering versions with pattern : " + patternString));
        Pattern p = Pattern.compile(patternString);
        ListIterator<ApplicationVersionDescription> appVersionIterator = appVersionList.listIterator();
        while (appVersionIterator.hasNext()) {
            if (p.matcher(appVersionIterator.next().getVersionLabel()).matches()) continue;
            appVersionIterator.remove();
        }
    }
}

