/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.beanstalk.version;

import br.com.ingenieux.mojo.beanstalk.AbstractBeanstalkMojo;
import com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionRequest;
import com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsResult;
import com.amazonaws.services.elasticbeanstalk.model.S3Location;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="create-application-version")
public class CreateApplicationVersionMojo
extends AbstractBeanstalkMojo {
    @Parameter(property="beanstalk.applicationName", defaultValue="${project.artifactId}", required=true)
    String applicationName;
    @Parameter(property="beanstalk.versionDescription", defaultValue="Update from beanstalk-maven-plugin")
    String versionDescription;
    @Parameter(property="beanstalk.autoCreateApplication", defaultValue="true")
    boolean autoCreateApplication;
    @Parameter(property="beanstalk.s3Bucket", defaultValue="${project.artifactId}", required=true)
    String s3Bucket;
    @Parameter(property="beanstalk.s3Key", defaultValue="${project.artifactId}/${project.build.finalName}-${beanstalk.versionLabel}.${project.packaging}", required=true)
    String s3Key;
    @Parameter(property="beanstalk.versionLabel", defaultValue="${project.version}", required=true)
    String versionLabel;
    @Parameter(property="beanstalk.skipExisting", defaultValue="true")
    boolean skipExisting;

    protected Object executeInternal() throws MojoExecutionException {
        if (this.skipExisting && this.versionLabelExists()) {
            this.getLog().info((CharSequence)("VersionLabel " + this.versionLabel + " already exists. Skipping creation of new application-version"));
            return null;
        }
        CreateApplicationVersionRequest request = new CreateApplicationVersionRequest();
        request.setApplicationName(this.applicationName);
        request.setDescription(this.versionDescription);
        request.setAutoCreateApplication(Boolean.valueOf(this.autoCreateApplication));
        if (StringUtils.isNotBlank((String)this.s3Bucket) && StringUtils.isNotBlank((String)this.s3Key)) {
            request.setSourceBundle(new S3Location(this.s3Bucket, this.s3Key));
        }
        request.setDescription(this.versionDescription);
        request.setVersionLabel(this.versionLabel);
        CreateApplicationVersionResult result = this.getService().createApplicationVersion(request);
        return result.getApplicationVersion();
    }

    private boolean versionLabelExists() {
        DescribeApplicationVersionsRequest davRequest = new DescribeApplicationVersionsRequest().withApplicationName(this.applicationName).withVersionLabels(new String[]{this.versionLabel});
        DescribeApplicationVersionsResult result = this.getService().describeApplicationVersions(davRequest);
        return !result.getApplicationVersions().isEmpty();
    }
}

