/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.beanstalk.version;

import br.com.ingenieux.mojo.beanstalk.AbstractNeedsEnvironmentMojo;
import com.amazonaws.services.elasticbeanstalk.model.ApplicationVersionDescription;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsResult;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentDescription;
import com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="rollback-version")
public class RollbackVersionMojo
extends AbstractNeedsEnvironmentMojo {
    @Parameter(property="beanstalk.dryRun", defaultValue="true")
    boolean dryRun;
    @Parameter(property="beanstalk.latestVersionInstead")
    boolean latestVersionInstead;

    protected Object executeInternal() throws MojoExecutionException, MojoFailureException {
        DescribeApplicationVersionsRequest describeApplicationVersionsRequest = new DescribeApplicationVersionsRequest().withApplicationName(this.applicationName);
        DescribeApplicationVersionsResult appVersions = this.getService().describeApplicationVersions(describeApplicationVersionsRequest);
        DescribeEnvironmentsRequest describeEnvironmentsRequest = new DescribeEnvironmentsRequest().withApplicationName(this.applicationName).withEnvironmentIds(new String[]{this.curEnv.getEnvironmentId()}).withEnvironmentNames(new String[]{this.curEnv.getEnvironmentName()}).withIncludeDeleted(Boolean.valueOf(false));
        DescribeEnvironmentsResult environments = this.getService().describeEnvironments(describeEnvironmentsRequest);
        ArrayList appVersionList = new ArrayList(appVersions.getApplicationVersions());
        List environmentList = environments.getEnvironments();
        if (environmentList.isEmpty()) {
            throw new MojoFailureException("No environments were found");
        }
        EnvironmentDescription d = (EnvironmentDescription)environmentList.get(0);
        Collections.sort(appVersionList, new Comparator<ApplicationVersionDescription>(){

            @Override
            public int compare(ApplicationVersionDescription o1, ApplicationVersionDescription o2) {
                return new CompareToBuilder().append((Object)o1.getDateUpdated(), (Object)o2.getDateUpdated()).toComparison();
            }
        });
        Collections.reverse(appVersionList);
        if (this.latestVersionInstead) {
            ApplicationVersionDescription latestVersionDescription = (ApplicationVersionDescription)appVersionList.get(0);
            return this.changeToVersion(d, latestVersionDescription);
        }
        ListIterator versionIterator = appVersionList.listIterator();
        String curVersionLabel = d.getVersionLabel();
        while (versionIterator.hasNext()) {
            ApplicationVersionDescription versionDescription = (ApplicationVersionDescription)versionIterator.next();
            String versionLabel = versionDescription.getVersionLabel();
            if (!curVersionLabel.equals(versionLabel) || !versionIterator.hasNext()) continue;
            return this.changeToVersion(d, (ApplicationVersionDescription)versionIterator.next());
        }
        throw new MojoFailureException("No previous version was found (current version: " + curVersionLabel);
    }

    Object changeToVersion(EnvironmentDescription d, ApplicationVersionDescription latestVersionDescription) {
        String curVersionLabel = d.getVersionLabel();
        String versionLabel = latestVersionDescription.getVersionLabel();
        UpdateEnvironmentRequest request = new UpdateEnvironmentRequest().withEnvironmentId(d.getEnvironmentId()).withVersionLabel(versionLabel);
        this.getLog().info((CharSequence)("Changing versionLabel for Environment[name=" + this.curEnv.getEnvironmentName() + "; environmentId=" + this.curEnv.getEnvironmentId() + "] from version " + curVersionLabel + " to version " + latestVersionDescription.getVersionLabel()));
        if (this.dryRun) {
            return null;
        }
        return this.getService().updateEnvironment(request);
    }
}

