/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.aws.util;

import br.com.ingenieux.mojo.aws.util.ServiceEndpointFormatter;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.reflect.ConstructorUtils;

public class AWSClientFactory {
    private AWSCredentials creds;
    private ClientConfiguration clientConfiguration;
    private String region;

    public AWSClientFactory(AWSCredentials creds, ClientConfiguration clientConfiguration, String region) {
        this.creds = creds;
        this.clientConfiguration = clientConfiguration;
        this.region = region;
    }

    public <T> T getService(Class<T> serviceClazz) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object resultObj = ConstructorUtils.invokeConstructor(serviceClazz, (Object[])new Object[]{this.creds, this.clientConfiguration}, (Class[])new Class[]{AWSCredentials.class, ClientConfiguration.class});
        if (StringUtils.isNotBlank((String)this.region)) {
            for (ServiceEndpointFormatter formatter : ServiceEndpointFormatter.values()) {
                if (!formatter.matches(resultObj)) continue;
                ((AmazonWebServiceClient)resultObj).setEndpoint(this.getEndpointFor(formatter));
                break;
            }
        }
        return (T)resultObj;
    }

    protected String getEndpointFor(ServiceEndpointFormatter formatter) {
        return String.format(formatter.serviceMask, this.region);
    }
}

