/*
 * Decompiled with CFR 0.152.
 */
package reconf.client.config.source;

import java.lang.reflect.Method;
import org.apache.commons.lang.StringUtils;
import reconf.client.adapters.ConfigurationAdapter;
import reconf.client.config.source.ConfigurationSource;
import reconf.client.locator.ServiceLocator;
import reconf.client.setup.DatabaseManager;
import reconf.infra.i18n.MessagesBundle;
import reconf.infra.log.LoggerHolder;

public class DatabaseConfigurationSource
implements ConfigurationSource {
    private static final MessagesBundle msg = MessagesBundle.getBundle(DatabaseConfigurationSource.class);
    private final String fullProperty;
    private final ConfigurationAdapter adapter;
    private final Method method;
    private final ServiceLocator locator;

    public DatabaseConfigurationSource(String fullProperty, Method method, ConfigurationAdapter adapter, ServiceLocator locator) {
        if (StringUtils.isBlank((String)fullProperty)) {
            throw new NullPointerException(msg.get("error.stub"));
        }
        if (null == adapter) {
            adapter = ConfigurationAdapter.noConfigurationAdapter;
        }
        if (null == method) {
            throw new NullPointerException(msg.get("error.method"));
        }
        this.fullProperty = fullProperty;
        this.adapter = adapter;
        this.method = method;
        this.locator = locator;
    }

    @Override
    public String get() {
        try {
            DatabaseManager proxy = this.locator.databaseManagerLocator().find();
            return proxy.get(this.fullProperty, this.method);
        }
        catch (Throwable t) {
            LoggerHolder.getLog().error(msg.format("error.load", new Object[]{this.getClass().getName()}), t);
            return null;
        }
    }

    @Override
    public void update(String value) {
        try {
            DatabaseManager manager = this.locator.databaseManagerLocator().find();
            manager.upsert(this.fullProperty, this.method, value);
        }
        catch (Throwable t) {
            LoggerHolder.getLog().error(msg.get("error.save"), t);
        }
    }

    @Override
    public void temporaryUpdate(String value) {
        try {
            DatabaseManager manager = this.locator.databaseManagerLocator().find();
            manager.temporaryUpsert(this.fullProperty, this.method, value);
        }
        catch (Throwable t) {
            LoggerHolder.getLog().error(msg.get("error.save"), t);
        }
    }

    @Override
    public ConfigurationAdapter getAdapter() {
        return this.adapter;
    }
}

