/*
 * Decompiled with CFR 0.152.
 */
package reconf.client.config.source;

import org.apache.commons.lang.StringUtils;
import reconf.client.adapters.ConfigurationAdapter;
import reconf.client.config.source.ConfigurationSource;
import reconf.infra.http.ServerStub;
import reconf.infra.i18n.MessagesBundle;
import reconf.infra.log.LoggerHolder;

public class RemoteConfigurationSource
implements ConfigurationSource {
    private static final MessagesBundle msg = MessagesBundle.getBundle(RemoteConfigurationSource.class);
    private final String key;
    private final ServerStub stub;
    private final ConfigurationAdapter adapter;

    public RemoteConfigurationSource(String key, ServerStub stub, ConfigurationAdapter adapter) {
        if (null == stub) {
            throw new NullPointerException(msg.get("error.stub"));
        }
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException(msg.get("error.key"));
        }
        if (null == adapter) {
            adapter = ConfigurationAdapter.noConfigurationAdapter;
        }
        this.key = key;
        this.stub = stub;
        this.adapter = adapter;
    }

    @Override
    public String get() {
        try {
            return this.stub.get(this.key);
        }
        catch (Throwable t) {
            LoggerHolder.getLog().error(msg.format("error.load", new Object[]{this.getClass().getName()}), t);
            return null;
        }
    }

    @Override
    public ConfigurationAdapter getAdapter() {
        return this.adapter;
    }

    @Override
    public void update(String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void temporaryUpdate(String value) {
        throw new UnsupportedOperationException();
    }
}

