/*
 * Decompiled with CFR 0.152.
 */
package reconf.client.config.update;

import java.util.ArrayList;
import java.util.List;
import reconf.client.elements.ConfigurationItemElement;
import reconf.client.elements.ConfigurationRepositoryElement;
import reconf.client.locator.ServiceLocator;
import reconf.client.proxy.MethodConfiguration;

public class ConfigurationRepositoryData {
    private final ConfigurationRepositoryElement cfgRepository;
    private final List<MethodConfiguration> independentReload = new ArrayList<MethodConfiguration>();
    private final List<MethodConfiguration> atomicReload = new ArrayList<MethodConfiguration>();
    private final List<MethodConfiguration> doNotReload = new ArrayList<MethodConfiguration>();
    private final List<MethodConfiguration> all = new ArrayList<MethodConfiguration>();
    private final ServiceLocator locator;

    public ConfigurationRepositoryData(ConfigurationRepositoryElement arg, ServiceLocator locator) {
        this.cfgRepository = arg;
        this.locator = locator;
        this.findMethodsToProxy();
    }

    private void findMethodsToProxy() {
        for (ConfigurationItemElement item : this.cfgRepository.getConfigurationItems()) {
            MethodConfiguration methodCfg = new MethodConfiguration(this.cfgRepository, item, this.locator);
            this.all.add(methodCfg);
            switch (methodCfg.getReloadStrategy()) {
                case ATOMIC: {
                    this.atomicReload.add(methodCfg);
                    break;
                }
                case INDEPENDENT: {
                    this.independentReload.add(methodCfg);
                    break;
                }
                case NONE: {
                    this.doNotReload.add(methodCfg);
                }
            }
        }
    }

    public List<MethodConfiguration> getIndependentReload() {
        return new ArrayList<MethodConfiguration>(this.independentReload);
    }

    public List<MethodConfiguration> getAtomicReload() {
        return new ArrayList<MethodConfiguration>(this.atomicReload);
    }

    public List<MethodConfiguration> getDoNotReload() {
        return new ArrayList<MethodConfiguration>(this.doNotReload);
    }

    public List<MethodConfiguration> getAll() {
        return new ArrayList<MethodConfiguration>(this.all);
    }
}

