/*
 * Decompiled with CFR 0.152.
 */
package reconf.client.config.update;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import reconf.client.config.update.ConfigurationRepositoryData;
import reconf.client.elements.ConfigurationRepositoryElement;
import reconf.client.locator.ServiceLocator;
import reconf.client.proxy.MethodConfiguration;
import reconf.infra.i18n.MessagesBundle;
import reconf.infra.log.LoggerHolder;
import reconf.infra.system.LineSeparator;
import reconf.infra.throwables.ReConfInitializationError;
import reconf.infra.throwables.UpdateConfigurationRepositoryException;

public class ConfigurationRepositoryUpdater
implements Runnable {
    private static final MessagesBundle msg = MessagesBundle.getBundle(ConfigurationRepositoryUpdater.class);
    private final ConfigurationRepositoryElement cfgRepository;
    private final ConfigurationRepositoryData data;
    private Map<Method, Object> independentMethodValue = new ConcurrentHashMap<Method, Object>();
    private Map<Method, Object> atomicMethodValue = new ConcurrentHashMap<Method, Object>();
    private ServiceLocator locator;

    public ConfigurationRepositoryUpdater(ConfigurationRepositoryElement elem, ServiceLocator locator) {
        this.locator = locator;
        this.cfgRepository = elem;
        this.data = new ConfigurationRepositoryData(elem, locator);
        this.load();
        this.scheduleIndependent();
    }

    public void syncNow(Class<? extends RuntimeException> cls) {
        this.sync(cls);
    }

    @Override
    public void run() {
        try {
            this.update();
        }
        catch (Throwable t) {
            LoggerHolder.getLog().error(msg.format("error.reloading.all.items", new Object[]{this.cfgRepository.getInterfaceClass()}), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        CountDownLatch latch = new CountDownLatch(this.data.getAll().size() + this.data.getAtomicReload().size());
        ExecutorService service = Executors.newFixedThreadPool(this.data.getAll().size() + this.data.getAtomicReload().size());
        ConcurrentHashMap<Method, Object> remote = new ConcurrentHashMap<Method, Object>();
        ConcurrentHashMap<Method, Object> local = new ConcurrentHashMap<Method, Object>();
        try {
            for (MethodConfiguration methodConfiguration : this.data.getAll()) {
                if (MethodConfiguration.ReloadStrategy.INDEPENDENT == methodConfiguration.getReloadStrategy() || MethodConfiguration.ReloadStrategy.NONE == methodConfiguration.getReloadStrategy()) {
                    service.execute(this.locator.configurationUpdaterFactory().standard(this.independentMethodValue, methodConfiguration, latch));
                    continue;
                }
                service.execute(this.locator.configurationUpdaterFactory().remote(remote, methodConfiguration, latch));
                service.execute(this.locator.configurationUpdaterFactory().local(local, methodConfiguration, latch));
            }
            this.waitFor(latch);
        }
        catch (Exception ignored) {
            LoggerHolder.getLog().error(msg.format("error.load", new Object[]{this.cfgRepository.getInterfaceClass()}), (Throwable)ignored);
        }
        finally {
            service.shutdown();
        }
        if (remote.size() < local.size()) {
            for (Map.Entry entry : local.entrySet()) {
                this.atomicMethodValue.put((Method)entry.getKey(), entry.getValue());
            }
        } else {
            for (Map.Entry entry : remote.entrySet()) {
                this.atomicMethodValue.put((Method)entry.getKey(), entry.getValue());
            }
        }
        this.validateLoadResult();
    }

    private void waitFor(CountDownLatch latch) {
        try {
            LoggerHolder.getLog().debug(msg.format("waiting.load", new Object[]{this.cfgRepository.getInterfaceClass()}));
            latch.await();
            LoggerHolder.getLog().info(msg.format("end.load", new Object[]{this.cfgRepository.getInterfaceClass()}));
        }
        catch (InterruptedException ignored) {
            LoggerHolder.getLog().error(msg.format("error.load", new Object[]{this.cfgRepository.getInterfaceClass()}), (Throwable)ignored);
        }
    }

    private void validateLoadResult() {
        if (this.independentMethodValue.size() + this.atomicMethodValue.size() != this.data.getAll().size()) {
            throw new ReConfInitializationError(msg.format("error.missing.item", new Object[]{this.cfgRepository.getInterfaceClass()}));
        }
        for (MethodConfiguration config : this.data.getAll()) {
            if (null != config.getMethod()) continue;
            throw new ReConfInitializationError(msg.get("error.internal"));
        }
        this.commitTemporaryDatabaseChanges();
    }

    private void scheduleIndependent() {
        ScheduledExecutorService service = Executors.newScheduledThreadPool(this.data.getIndependentReload().size());
        for (MethodConfiguration config : this.data.getIndependentReload()) {
            service.scheduleAtFixedRate(this.locator.configurationUpdaterFactory().standard(this.independentMethodValue, config), config.getReloadInterval(), config.getReloadInterval(), config.getReloadTimeUnit());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        if (!this.shouldReload()) {
            return;
        }
        ExecutorService service = Executors.newFixedThreadPool(this.data.getAtomicReload().size());
        CountDownLatch latch = new CountDownLatch(this.data.getAtomicReload().size());
        ConcurrentHashMap<Method, Object> updated = new ConcurrentHashMap<Method, Object>();
        try {
            for (MethodConfiguration config : this.data.getAtomicReload()) {
                service.execute(this.locator.configurationUpdaterFactory().remote(updated, config, latch));
            }
            this.waitFor(latch);
            this.atomicMethodValue = this.mergeAtomicMethodObjectWith(updated);
        }
        catch (Exception ignored) {
            LoggerHolder.getLog().error(msg.format("error.load", new Object[]{this.cfgRepository.getInterfaceClass()}));
        }
        finally {
            service.shutdown();
        }
    }

    private Map<Method, Object> mergeAtomicMethodObjectWith(Map<Method, Object> updated) {
        if (!this.shouldMerge(updated)) {
            return this.atomicMethodValue;
        }
        ConcurrentHashMap<Method, Object> result = new ConcurrentHashMap<Method, Object>();
        for (Map.Entry<Method, Object> each : this.atomicMethodValue.entrySet()) {
            result.put(each.getKey(), !updated.containsKey(each.getKey()) ? each.getValue() : updated.get(each.getKey()));
        }
        this.commitTemporaryDatabaseChanges();
        return result;
    }

    private boolean shouldMerge(Map<Method, Object> updated) {
        ArrayList<String> notFound = new ArrayList<String>();
        for (Map.Entry<Method, Object> each : this.atomicMethodValue.entrySet()) {
            if (updated.get(each.getKey()) != null) continue;
            notFound.add(msg.format("error.retrieving.item", new Object[]{each.getKey()}));
        }
        if (notFound.isEmpty()) {
            return true;
        }
        LoggerHolder.getLog().warn(StringUtils.join(notFound, (String)LineSeparator.value()));
        LoggerHolder.getLog().warn(msg.get("error.retrieving.all.items"));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync(Class<? extends RuntimeException> cls) {
        ExecutorService service = Executors.newFixedThreadPool(this.data.getAll().size());
        CountDownLatch latch = new CountDownLatch(this.data.getAll().size());
        ConcurrentHashMap<Method, Object> updateAtomic = new ConcurrentHashMap<Method, Object>();
        ConcurrentHashMap<Method, Object> updateIndependent = new ConcurrentHashMap<Method, Object>();
        try {
            for (MethodConfiguration config : this.data.getAll()) {
                if (MethodConfiguration.ReloadStrategy.INDEPENDENT == config.getReloadStrategy() || MethodConfiguration.ReloadStrategy.NONE == config.getReloadStrategy()) {
                    service.submit(this.locator.configurationUpdaterFactory().remote(updateIndependent, config, latch));
                    continue;
                }
                service.submit(this.locator.configurationUpdaterFactory().remote(updateAtomic, config, latch));
            }
            this.waitFor(latch);
        }
        catch (Exception ignored) {
            LoggerHolder.getLog().error(msg.format("error.load", new Object[]{this.cfgRepository.getInterfaceClass()}));
        }
        finally {
            service.shutdown();
        }
        if (updateAtomic.size() + updateIndependent.size() != this.data.getAll().size()) {
            String error = msg.format("error.load", new Object[]{this.cfgRepository.getInterfaceClass()});
            try {
                Constructor<? extends RuntimeException> constructor = null;
                constructor = cls.getConstructor(String.class);
                constructor.setAccessible(true);
                throw cls.cast(constructor.newInstance(error));
            }
            catch (NoSuchMethodException ignored) {
                throw new UpdateConfigurationRepositoryException(error);
            }
            catch (InvocationTargetException ignored) {
                throw new UpdateConfigurationRepositoryException(error);
            }
            catch (InstantiationException ignored) {
                throw new UpdateConfigurationRepositoryException(error);
            }
            catch (IllegalAccessException ignored) {
                throw new UpdateConfigurationRepositoryException(error);
            }
        }
        this.finishSync(updateAtomic, updateIndependent);
    }

    private void finishSync(Map<Method, Object> updateAtomic, Map<Method, Object> updateIndependent) {
        ConcurrentHashMap<Method, Object> mergedAtomic = new ConcurrentHashMap<Method, Object>();
        for (Map.Entry<Method, Object> each : this.atomicMethodValue.entrySet()) {
            mergedAtomic.put(each.getKey(), !updateAtomic.containsKey(each.getKey()) ? each.getValue() : updateAtomic.get(each.getKey()));
        }
        ConcurrentHashMap<Method, Object> mergedIndependent = new ConcurrentHashMap<Method, Object>();
        for (Map.Entry<Method, Object> each : this.independentMethodValue.entrySet()) {
            mergedIndependent.put(each.getKey(), !updateIndependent.containsKey(each.getKey()) ? each.getValue() : updateIndependent.get(each.getKey()));
        }
        this.atomicMethodValue = mergedAtomic;
        this.independentMethodValue = mergedIndependent;
        this.commitTemporaryDatabaseChanges();
    }

    private void commitTemporaryDatabaseChanges() {
        this.locator.databaseManagerLocator().find().commitTemporaryUpdate(this.cfgRepository.getFullProperties(), this.cfgRepository.getInterfaceClass());
    }

    public int getReloadInterval() {
        if (!this.shouldReload()) {
            return 0;
        }
        return this.cfgRepository.getUpdateFrequency().getInterval();
    }

    public TimeUnit getReloadTimeUnit() {
        if (!this.shouldReload()) {
            return TimeUnit.DAYS;
        }
        return this.cfgRepository.getUpdateFrequency().getTimeUnit();
    }

    public Object getValueOf(Method m) {
        return this.atomicMethodValue.containsKey(m) ? this.atomicMethodValue.get(m) : (this.independentMethodValue.containsKey(m) ? this.independentMethodValue.get(m) : null);
    }

    public boolean shouldReload() {
        return !this.data.getAtomicReload().isEmpty();
    }
}

