/*
 * Decompiled with CFR 0.152.
 */
package reconf.client.config.update;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import reconf.client.config.source.ConfigurationSource;
import reconf.client.config.source.ConfigurationSourceHolder;
import reconf.client.constructors.MethodData;
import reconf.client.factory.ObjectConstructorFactory;
import reconf.client.proxy.MethodConfiguration;
import reconf.infra.i18n.MessagesBundle;
import reconf.infra.log.LoggerHolder;

public class ConfigurationUpdater
implements Runnable {
    protected static final MessagesBundle msg = MessagesBundle.getBundle(ConfigurationUpdater.class);
    protected final Map<Method, Object> methodValue;
    protected final MethodConfiguration methodCfg;
    protected final CountDownLatch latch;

    public ConfigurationUpdater(Map<Method, Object> toUpdate, MethodConfiguration target) {
        this.methodValue = toUpdate;
        this.methodCfg = target;
        this.latch = new CountDownLatch(0);
    }

    public ConfigurationUpdater(Map<Method, Object> toUpdate, MethodConfiguration target, CountDownLatch latch) {
        this.methodValue = toUpdate;
        this.methodCfg = target;
        this.latch = latch;
    }

    @Override
    public void run() {
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update() {
        String value = null;
        ConfigurationSource obtained = null;
        try {
            LoggerHolder.getLog().debug(msg.format("method.reload", new Object[]{this.getClass().getName(), this.methodCfg.getMethod().getName()}));
            ConfigurationSourceHolder holder = this.methodCfg.getConfigurationSourceHolder();
            value = holder.getRemote().get();
            if (null != value) {
                obtained = holder.getRemote();
                holder.getDb().update(value);
            } else {
                value = holder.getDb().get();
                if (value != null) {
                    obtained = holder.getDb();
                }
            }
            if (value != null && obtained != null) {
                this.updateMap(value, obtained);
            }
        }
        catch (Throwable t) {
            LoggerHolder.getLog().error(msg.format("error.load", new Object[]{this.getClass().getName()}), t);
        }
        finally {
            this.releaseLatch();
        }
    }

    protected void updateMap(String value, ConfigurationSource obtained) throws Throwable {
        Class<?> clazz = this.methodCfg.getMethod().getReturnType();
        MethodData data = null;
        data = clazz.isArray() ? new MethodData(this.methodCfg.getMethod(), clazz.getComponentType(), value, obtained.getAdapter()) : (Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz) ? new MethodData(this.methodCfg.getMethod(), this.methodCfg.getMethod().getGenericReturnType(), value, obtained.getAdapter()) : new MethodData(this.methodCfg.getMethod(), clazz, value, obtained.getAdapter()));
        Object result = ObjectConstructorFactory.get(clazz).construct(data);
        this.methodValue.put(this.methodCfg.getMethod(), result);
    }

    protected void releaseLatch() {
        if (this.latch != null) {
            this.latch.countDown();
        }
    }
}

