/*
 * Decompiled with CFR 0.152.
 */
package reconf.client.constructors;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.util.List;
import reconf.client.constructors.MethodData;
import reconf.client.constructors.ObjectConstructor;
import reconf.client.constructors.StringParser;
import reconf.client.factory.ObjectConstructorFactory;

public class ArrayConstructor
implements ObjectConstructor {
    @Override
    public Object construct(MethodData data) throws Throwable {
        Class<?> returnClass;
        if (data.hasAdapter()) {
            return data.getAdapter().adapt(data.getValue());
        }
        if (data.getReturnType() instanceof Class) {
            Class<?> cast = (Class<?>)data.getReturnType();
            returnClass = null == cast.getComponentType() ? cast : cast.getComponentType();
        } else if (data.getReturnType() instanceof GenericArrayType) {
            returnClass = (Class<?>)((GenericArrayType)data.getReturnType()).getGenericComponentType();
        } else {
            throw new UnsupportedOperationException();
        }
        if (null == data.getValue()) {
            return Array.newInstance(returnClass, 0);
        }
        List<String> parsed = new StringParser(data.getValue()).getTokens();
        Object result = Array.newInstance(returnClass, parsed.size());
        for (int i = 0; i < parsed.size(); ++i) {
            Array.set(result, i, ObjectConstructorFactory.get(returnClass).construct(new MethodData(data.getMethod(), returnClass, parsed.get(i))));
        }
        return result;
    }
}

