/*
 * Decompiled with CFR 0.152.
 */
package reconf.client.constructors;

import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.commons.lang.ArrayUtils;
import reconf.client.constructors.MethodData;
import reconf.client.constructors.ObjectConstructor;
import reconf.client.constructors.StringParser;
import reconf.client.factory.ObjectConstructorFactory;
import reconf.infra.i18n.MessagesBundle;

public class CollectionConstructor
implements ObjectConstructor {
    private static final MessagesBundle msg = MessagesBundle.getBundle(CollectionConstructor.class);

    @Override
    public Object construct(MethodData data) throws Throwable {
        ParameterizedType parameterized;
        if (data.hasAdapter()) {
            return data.getAdapter().adapt(data.getValue());
        }
        Class returnClass = null;
        Object innerClass = null;
        if (data.getReturnType() instanceof ParameterizedType) {
            parameterized = (ParameterizedType)data.getReturnType();
            returnClass = (Class)parameterized.getRawType();
            if (parameterized.getActualTypeArguments()[0] instanceof ParameterizedType) {
                innerClass = parameterized.getActualTypeArguments()[0];
            } else if (parameterized.getActualTypeArguments()[0] instanceof Class) {
                innerClass = parameterized.getActualTypeArguments()[0];
            }
        } else if (data.getReturnType() instanceof Class) {
            returnClass = (Class)data.getReturnType();
            if (returnClass.getGenericSuperclass() != null && returnClass.getGenericSuperclass() instanceof ParameterizedType) {
                parameterized = (ParameterizedType)returnClass.getGenericSuperclass();
                if (parameterized.getActualTypeArguments().length != 1) {
                    throw new IllegalArgumentException(msg.format("error.cant.build.type", new Object[]{data.getReturnType()}));
                }
                if (parameterized.getActualTypeArguments()[0] instanceof TypeVariable) {
                    throw new IllegalArgumentException(msg.format("error.cant.build.type", new Object[]{data.getReturnType()}));
                }
                innerClass = parameterized.getActualTypeArguments()[0];
            } else {
                innerClass = Object.class;
            }
        } else {
            throw new IllegalArgumentException(msg.get("error.return"));
        }
        if (returnClass.isInterface()) {
            returnClass = this.getDefaultImplementation(returnClass);
        }
        Constructor constructor = returnClass.getConstructor(ArrayUtils.EMPTY_CLASS_ARRAY);
        Collection collectionInstance = (Collection)constructor.newInstance(ArrayUtils.EMPTY_OBJECT_ARRAY);
        if (null == data.getValue()) {
            return collectionInstance;
        }
        for (String s : new StringParser(data.getValue()).getTokens()) {
            Object o = ObjectConstructorFactory.get((Type)innerClass).construct(new MethodData(data.getMethod(), (Type)innerClass, s));
            if (o == null) continue;
            collectionInstance.add(o);
        }
        return collectionInstance;
    }

    private Class<?> getDefaultImplementation(Class<?> returnClass) {
        if (Collection.class.equals(returnClass)) {
            return ArrayList.class;
        }
        if (List.class.equals(returnClass)) {
            return ArrayList.class;
        }
        if (Set.class.equals(returnClass)) {
            return HashSet.class;
        }
        if (SortedSet.class.equals(returnClass) || NavigableSet.class.equals(returnClass)) {
            return TreeSet.class;
        }
        if (Queue.class.equals(returnClass)) {
            return LinkedList.class;
        }
        if (BlockingQueue.class.equals(returnClass)) {
            return ArrayBlockingQueue.class;
        }
        if (BlockingDeque.class.equals(returnClass)) {
            return LinkedBlockingDeque.class;
        }
        throw new UnsupportedOperationException(msg.format("error.implementation", new Object[]{returnClass}));
    }
}

