/*
 * Decompiled with CFR 0.152.
 */
package reconf.client.constructors;

import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import reconf.client.constructors.MethodData;
import reconf.client.constructors.ObjectConstructor;
import reconf.client.constructors.StringParser;
import reconf.client.factory.ObjectConstructorFactory;
import reconf.infra.i18n.MessagesBundle;

public class MapConstructor
implements ObjectConstructor {
    private static final MessagesBundle msg = MessagesBundle.getBundle(MapConstructor.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object construct(MethodData data) throws Throwable {
        ParameterizedType parameterized;
        if (data.hasAdapter()) {
            return data.getAdapter().adapt(data.getValue());
        }
        Class returnClass = null;
        Object keyType = null;
        Object valueType = null;
        if (data.getReturnType() instanceof ParameterizedType) {
            parameterized = (ParameterizedType)data.getReturnType();
            returnClass = (Class)parameterized.getRawType();
            if (parameterized.getActualTypeArguments().length == 1) {
                Type first = parameterized.getActualTypeArguments()[0];
                if (returnClass.getGenericSuperclass() != null && returnClass.getGenericSuperclass() instanceof ParameterizedType) {
                    parameterized = (ParameterizedType)returnClass.getGenericSuperclass();
                    if (parameterized.getActualTypeArguments().length != 2) {
                        throw new IllegalArgumentException(msg.format("error.cant.build.type", new Object[]{data.getReturnType()}));
                    }
                    if (parameterized.getActualTypeArguments()[0] instanceof TypeVariable) {
                        keyType = first;
                        valueType = parameterized.getActualTypeArguments()[1];
                    } else {
                        if (!(parameterized.getActualTypeArguments()[1] instanceof TypeVariable)) throw new IllegalArgumentException(msg.format("error.cant.build.type", new Object[]{data.getReturnType()}));
                        valueType = first;
                        keyType = parameterized.getActualTypeArguments()[0];
                    }
                }
            } else {
                keyType = parameterized.getActualTypeArguments()[0];
                valueType = parameterized.getActualTypeArguments()[1];
            }
        } else {
            if (!(data.getReturnType() instanceof Class)) throw new IllegalArgumentException(msg.get("error.return"));
            returnClass = (Class)data.getReturnType();
            if (returnClass.getGenericSuperclass() != null && returnClass.getGenericSuperclass() instanceof ParameterizedType) {
                parameterized = (ParameterizedType)returnClass.getGenericSuperclass();
                if (parameterized.getActualTypeArguments().length != 2) {
                    throw new IllegalArgumentException(msg.format("error.cant.build.type", new Object[]{data.getReturnType()}));
                }
                keyType = parameterized.getActualTypeArguments()[0];
                valueType = parameterized.getActualTypeArguments()[1];
            } else {
                keyType = Object.class;
                valueType = Object.class;
            }
        }
        if (returnClass.isInterface()) {
            returnClass = this.getDefaultImplementation(returnClass);
        }
        Constructor constructor = returnClass.getConstructor(ArrayUtils.EMPTY_CLASS_ARRAY);
        Map mapInstance = (Map)constructor.newInstance(ArrayUtils.EMPTY_OBJECT_ARRAY);
        if (null == data.getValue() || StringUtils.isEmpty((String)data.getValue())) {
            return mapInstance;
        }
        if (!(keyType instanceof Class && StringUtils.startsWith((String)data.getValue(), (String)"[") && StringUtils.endsWith((String)data.getValue(), (String)"]"))) {
            throw new IllegalArgumentException(msg.format("error.build", new Object[]{data.getValue()}));
        }
        StringParser parser = new StringParser(data.getValue());
        for (Map.Entry<String, String> each : parser.getTokensAsMap().entrySet()) {
            Object value = valueType instanceof Class ? ObjectConstructorFactory.get((Type)valueType).construct(new MethodData(data.getMethod(), (Type)valueType, each.getValue())) : ObjectConstructorFactory.get((Type)valueType).construct(new MethodData(data.getMethod(), (Type)valueType, each.getValue()));
            mapInstance.put(ObjectConstructorFactory.get((Type)keyType).construct(new MethodData(data.getMethod(), (Type)keyType, each.getKey())), value);
        }
        return mapInstance;
    }

    private Class<?> getDefaultImplementation(Class<?> returnClass) {
        if (Map.class.equals(returnClass)) {
            return HashMap.class;
        }
        if (ConcurrentMap.class.equals(returnClass)) {
            return ConcurrentHashMap.class;
        }
        if (ConcurrentNavigableMap.class.equals(returnClass)) {
            return ConcurrentSkipListMap.class;
        }
        if (NavigableMap.class.equals(returnClass) || SortedMap.class.equals(returnClass)) {
            return TreeMap.class;
        }
        throw new UnsupportedOperationException(msg.format("error.implementation", new Object[]{returnClass}));
    }
}

