/*
 * Decompiled with CFR 0.152.
 */
package reconf.client.constructors;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.CharUtils;
import org.apache.commons.lang.StringUtils;
import reconf.client.constructors.MethodData;
import reconf.client.constructors.ObjectConstructor;
import reconf.infra.i18n.MessagesBundle;

public class SimpleConstructor
implements ObjectConstructor {
    private static final MessagesBundle msg = MessagesBundle.getBundle(SimpleConstructor.class);
    private static final Map<Class<?>, Class<?>> primitiveBoxing = new HashMap<Class<?>, Class<?>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(Integer.TYPE, Integer.class);
            this.put(Long.TYPE, Long.class);
            this.put(Byte.TYPE, Byte.class);
            this.put(Short.TYPE, Short.class);
            this.put(Double.TYPE, Double.class);
            this.put(Float.TYPE, Float.class);
            this.put(Boolean.TYPE, Boolean.class);
        }
    };

    @Override
    public Object construct(MethodData data) throws Throwable {
        if (data.hasAdapter()) {
            return data.getAdapter().adapt(data.getValue());
        }
        Class<String> returnClass = (Class<String>)((Object)data.getReturnType());
        String trimmed = StringUtils.defaultString((String)StringUtils.trim((String)data.getValue()));
        if (!trimmed.startsWith("'") || !trimmed.endsWith("'")) {
            throw new RuntimeException(msg.format("error.invalid.string", new Object[]{data.getValue()}));
        }
        String wholeValue = StringUtils.substring((String)trimmed, (int)1, (int)(trimmed.length() - 1));
        if (String.class.equals((Object)returnClass)) {
            return wholeValue;
        }
        if (null == data.getValue()) {
            return null;
        }
        if (Object.class.equals((Object)returnClass)) {
            returnClass = String.class;
        }
        if (Character.TYPE.equals(data.getReturnType()) || Character.class.equals((Object)data.getReturnType())) {
            if (StringUtils.length((String)wholeValue) == 1) {
                return Character.valueOf(CharUtils.toChar((String)wholeValue));
            }
            return Character.valueOf(CharUtils.toChar((String)StringUtils.replace((String)wholeValue, (String)" ", (String)"")));
        }
        if (primitiveBoxing.containsKey(returnClass)) {
            if (StringUtils.isBlank((String)wholeValue)) {
                return null;
            }
            Method parser = primitiveBoxing.get(returnClass).getMethod("parse" + StringUtils.capitalize((String)returnClass.getSimpleName()), String.class);
            return parser.invoke(primitiveBoxing.get(returnClass), StringUtils.trim((String)wholeValue));
        }
        Method valueOf = null;
        try {
            valueOf = returnClass.getMethod("valueOf", String.class);
        }
        catch (NoSuchMethodException ignored) {
            // empty catch block
        }
        if (valueOf == null) {
            try {
                valueOf = returnClass.getMethod("valueOf", Object.class);
            }
            catch (NoSuchMethodException ignored) {
                // empty catch block
            }
        }
        if (null != valueOf) {
            if (StringUtils.isEmpty((String)wholeValue)) {
                return null;
            }
            return valueOf.invoke((Object)data.getReturnType(), StringUtils.trim((String)wholeValue));
        }
        Constructor constructor = null;
        try {
            constructor = returnClass.getConstructor(String.class);
            constructor.setAccessible(true);
        }
        catch (NoSuchMethodException ignored) {
            throw new IllegalStateException(msg.format("error.string.constructor", new Object[]{returnClass.getSimpleName()}));
        }
        try {
            return constructor.newInstance(wholeValue);
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof NumberFormatException) {
                return constructor.newInstance(StringUtils.trim((String)wholeValue));
            }
            throw e;
        }
    }
}

