/*
 * Decompiled with CFR 0.152.
 */
package reconf.client.constructors;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import reconf.infra.i18n.MessagesBundle;
import reconf.infra.system.LineSeparator;

public class StringParser {
    private static final MessagesBundle msg = MessagesBundle.getBundle(StringParser.class);
    private List<String> tokens = new ArrayList<String>();
    private final Stack<Character> openClose = new Stack();

    public StringParser(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return;
        }
        String trimmed = StringUtils.defaultString((String)StringUtils.trim((String)value));
        if (!trimmed.startsWith("[") || !trimmed.endsWith("]")) {
            throw new RuntimeException(msg.get("error.complex.type"));
        }
        String wholeValue = StringUtils.substring((String)trimmed, (int)1, (int)(trimmed.length() - 1));
        this.extractTokens(wholeValue);
        if (this.openClose.size() % 2 != 0) {
            throw new IllegalArgumentException(msg.format("error.invalid.string", new Object[]{value}));
        }
    }

    private void extractTokens(String arg) {
        boolean colOpen = false;
        boolean valueOpen = false;
        boolean escaped = false;
        Stack<Character> token = new Stack<Character>();
        for (int i = 0; i < arg.length(); ++i) {
            StringBuilder sb;
            char c = arg.charAt(i);
            if (colOpen) {
                if (']' == c && !valueOpen) {
                    token.push(Character.valueOf(c));
                    this.openClose.push(Character.valueOf(c));
                    colOpen = false;
                    sb = new StringBuilder(token.size());
                    for (Character each : token) {
                        sb.append(each);
                    }
                    this.tokens.add(sb.toString());
                    token.clear();
                    continue;
                }
                if ('\'' == c) {
                    if (!valueOpen) {
                        valueOpen = true;
                    } else if (valueOpen && escaped) {
                        token.pop();
                        escaped = false;
                    } else {
                        valueOpen = false;
                    }
                }
                if ('\\' == c) {
                    if (!escaped) {
                        token.push(Character.valueOf(c));
                        escaped = true;
                        continue;
                    }
                    escaped = false;
                    continue;
                }
                if (escaped) {
                    escaped = false;
                }
                token.push(Character.valueOf(c));
                continue;
            }
            if (valueOpen) {
                if ('\'' == c) {
                    if (escaped) {
                        token.pop();
                        token.push(Character.valueOf(c));
                        escaped = false;
                        continue;
                    }
                    valueOpen = false;
                    token.push(Character.valueOf(c));
                    this.openClose.push(Character.valueOf(c));
                    sb = new StringBuilder(token.size());
                    for (Character each : token) {
                        sb.append(each);
                    }
                    this.tokens.add(sb.toString());
                    token.clear();
                    continue;
                }
                if ('\\' == c) {
                    if (!escaped) {
                        token.push(Character.valueOf(c));
                        escaped = true;
                        continue;
                    }
                    escaped = false;
                    continue;
                }
                if (escaped) {
                    escaped = false;
                }
                token.push(Character.valueOf(c));
                continue;
            }
            if ('[' == c) {
                colOpen = true;
                token.push(Character.valueOf(c));
                this.openClose.push(Character.valueOf(c));
                continue;
            }
            if ('\'' != c) continue;
            valueOpen = true;
            token.push(Character.valueOf(c));
            this.openClose.push(Character.valueOf(c));
        }
    }

    public List<String> getTokens() {
        return new ArrayList<String>(this.tokens);
    }

    public Map<String, String> getTokensAsMap() {
        if (this.tokens.size() % 2 != 0) {
            throw new IllegalStateException(msg.format("error.map", new Object[]{LineSeparator.value(), this.tokens}));
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        String current = "";
        for (int i = 0; i < this.tokens.size(); ++i) {
            if (i % 2 == 0) {
                current = this.tokens.get(i);
                continue;
            }
            result.put(current, this.tokens.get(i));
        }
        return result;
    }
}

