/*
 * Decompiled with CFR 0.152.
 */
package reconf.client.elements;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.hibernate.validator.constraints.NotEmpty;
import reconf.client.adapters.ConfigurationAdapter;
import reconf.client.annotations.ConfigurationItem;
import reconf.client.annotations.DoNotUpdate;
import reconf.client.annotations.UpdateConfigurationRepository;
import reconf.client.annotations.UpdateFrequency;
import reconf.client.elements.ConfigurationRepositoryElement;
import reconf.client.elements.DoNotUpdateElement;
import reconf.client.elements.UpdateFrequencyElement;
import reconf.infra.i18n.MessagesBundle;
import reconf.infra.log.LoggerHolder;
import reconf.infra.throwables.ReConfInitializationError;

public class ConfigurationItemElement {
    private static final MessagesBundle msg = MessagesBundle.getBundle(ConfigurationItemElement.class);
    private String methodName;
    private Method method;
    private String value;
    private String component;
    private String product;
    private DoNotUpdateElement doNotUpdate;
    private UpdateFrequencyElement updateFrequency;
    private Class<? extends ConfigurationAdapter> adapter;

    public static List<ConfigurationItemElement> from(ConfigurationRepositoryElement repository) {
        ArrayList<ConfigurationItemElement> result = new ArrayList<ConfigurationItemElement>();
        for (Method method : repository.getInterfaceClass().getMethods()) {
            ConfigurationItem ann = method.getAnnotation(ConfigurationItem.class);
            if (ann == null) {
                if (method.isAnnotationPresent(UpdateConfigurationRepository.class)) continue;
                throw new ReConfInitializationError(msg.format("error.not.configured.method", new Object[]{method.toString()}));
            }
            ConfigurationItemElement resultItem = null;
            for (ConfigurationItemElement item : repository.getConfigurationItems()) {
                if (!StringUtils.equals((String)item.getMethodName(), (String)method.getName())) continue;
                resultItem = item;
            }
            if (resultItem == null) {
                resultItem = new ConfigurationItemElement();
                resultItem.setMethod(method.getName());
                resultItem.setAdapter(ann.adapter());
            }
            resultItem.setMethod(method);
            ConfigurationItemElement.defineUpdateStrategy(repository, resultItem, ann);
            ConfigurationItemElement.defineItemProductComponenetOverride(resultItem, ann);
            result.add(resultItem);
        }
        return result;
    }

    private static void defineUpdateStrategy(ConfigurationRepositoryElement repository, ConfigurationItemElement resultItem, ConfigurationItem annItem) {
        resultItem.setValue(annItem.value());
        if (resultItem.getMethod().isAnnotationPresent(UpdateFrequency.class)) {
            UpdateFrequency frequencyAnn = resultItem.getMethod().getAnnotation(UpdateFrequency.class);
            UpdateFrequencyElement frequencyElement = new UpdateFrequencyElement();
            frequencyElement.setInterval(frequencyAnn.interval());
            frequencyElement.setTimeUnit(frequencyAnn.timeUnit());
            resultItem.setUpdateFrequency(frequencyElement);
        }
        if (resultItem.getMethod().isAnnotationPresent(DoNotUpdate.class) && resultItem.getMethod().isAnnotationPresent(UpdateFrequency.class)) {
            LoggerHolder.getLog().warn(msg.format("error.conflict.reload.policy", new Object[]{resultItem.getMethod(), repository.getClass()}));
            return;
        }
        if (resultItem.getMethod().isAnnotationPresent(DoNotUpdate.class)) {
            resultItem.setDoNotUpdate(new DoNotUpdateElement());
        }
    }

    private static void defineItemProductComponenetOverride(ConfigurationItemElement resultItem, ConfigurationItem annItem) {
        if (StringUtils.isBlank((String)resultItem.getProduct()) && StringUtils.isNotBlank((String)annItem.product())) {
            resultItem.setProduct(annItem.product());
        }
        if (StringUtils.isBlank((String)resultItem.getComponent()) && StringUtils.isNotBlank((String)annItem.component())) {
            resultItem.setComponent(annItem.component());
        }
    }

    @NotNull(message="method.name.null")
    @NotEmpty(message="method.name.empty")
    public String getMethodName() {
        return this.methodName;
    }

    public void setMethod(String methodName) {
        this.methodName = methodName;
    }

    @NotNull(message="{elements.ConfigurationItemElement.error.value}")
    @NotEmpty(message="{elements.ConfigurationItemElement.error.value}")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @NotNull(message="adapter.null")
    public Class<? extends ConfigurationAdapter> getAdapter() {
        return this.adapter;
    }

    public void setAdapter(Class<? extends ConfigurationAdapter> adapter) {
        this.adapter = adapter;
    }

    @NotNull(message="method.null")
    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public DoNotUpdateElement getDoNotUpdate() {
        return this.doNotUpdate;
    }

    public void setDoNotUpdate(DoNotUpdateElement doNotUpdate) {
        this.doNotUpdate = doNotUpdate;
    }

    @Valid
    public UpdateFrequencyElement getUpdateFrequency() {
        return this.updateFrequency;
    }

    public void setUpdateFrequency(UpdateFrequencyElement updateFrequency) {
        this.updateFrequency = updateFrequency;
    }

    public String toString() {
        ToStringBuilder result = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("method", (Object)this.getMethod());
        this.addToString(result, "product", this.getProduct());
        this.addToString(result, "component", this.getComponent());
        result.append("value", (Object)this.getValue());
        result.append("@DoNotUpdate", (Object)(null == this.doNotUpdate ? "not found" : "found"));
        if (this.getUpdateFrequency() == null) {
            result.append("specific @UpdateFrequency", (Object)"not found");
        } else {
            result.append("specific @UpdateFrequency", (Object)this.getUpdateFrequency());
        }
        return result.toString();
    }

    private void addToString(ToStringBuilder arg, String key, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            arg.append(key, (Object)value);
        }
    }
}

