/*
 * Decompiled with CFR 0.152.
 */
package reconf.client.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.hibernate.validator.constraints.NotEmpty;
import reconf.client.elements.ConfigurationItemElement;
import reconf.client.elements.DoNotUpdateElement;
import reconf.client.elements.FullPropertyElement;
import reconf.client.elements.UpdateFrequencyElement;
import reconf.client.setup.ConnectionSettings;
import reconf.infra.system.LineSeparator;

public class ConfigurationRepositoryElement {
    private ConnectionSettings connectionSettings;
    private String product;
    private String component;
    private DoNotUpdateElement doNotUpdate;
    private UpdateFrequencyElement updateFrequency;
    private Class<?> interfaceClass;
    private List<ConfigurationItemElement> configurationItems = new ArrayList<ConfigurationItemElement>();

    @NotNull
    @Valid
    public ConnectionSettings getConnectionSettings() {
        return this.connectionSettings;
    }

    public void setConnectionSettings(ConnectionSettings connectionSettings) {
        this.connectionSettings = connectionSettings;
    }

    @NotNull(message="{elements.ConfigurationRepositoryElement.error.component}")
    @NotEmpty(message="{elements.ConfigurationRepositoryElement.error.component}")
    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public Collection<String> getFullProperties() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (ConfigurationItemElement elem : this.configurationItems) {
            String productName = null;
            productName = StringUtils.isEmpty((String)elem.getProduct()) ? this.getProduct() : elem.getProduct();
            String componentName = null;
            componentName = StringUtils.isEmpty((String)elem.getComponent()) ? this.getComponent() : elem.getComponent();
            result.add(FullPropertyElement.from(productName, componentName, elem.getValue()));
        }
        return result;
    }

    @NotNull(message="{elements.ConfigurationRepositoryElement.error.product}")
    @NotEmpty(message="{elements.ConfigurationRepositoryElement.error.product}")
    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public DoNotUpdateElement getDoNotUpdate() {
        return this.doNotUpdate;
    }

    public void setDoNotUpdate(DoNotUpdateElement doNotUpdate) {
        this.doNotUpdate = doNotUpdate;
    }

    @Valid
    public UpdateFrequencyElement getUpdateFrequency() {
        return this.updateFrequency;
    }

    public void setUpdateFrequency(UpdateFrequencyElement updateFrequency) {
        this.updateFrequency = updateFrequency;
    }

    @NotNull
    public Class<?> getInterfaceClass() {
        return this.interfaceClass;
    }

    public void setInterfaceClass(Class<?> interfaceClass) {
        this.interfaceClass = interfaceClass;
    }

    @Valid
    public List<ConfigurationItemElement> getConfigurationItems() {
        return this.configurationItems;
    }

    public void setConfigurationItems(List<ConfigurationItemElement> configurationItems) {
        this.configurationItems = configurationItems;
    }

    public String toString() {
        ToStringBuilder result = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("class", this.getInterfaceClass()).append("product", (Object)this.getProduct()).append("component", (Object)this.getComponent()).append("@DoNotUpdate", (Object)(null == this.doNotUpdate ? "not found" : "found"));
        if (this.getUpdateFrequency() == null) {
            result.append("@UpdateFrequency", (Object)"not found");
        } else {
            result.append("@UpdateFrequency", (Object)this.getUpdateFrequency());
        }
        result.append("@ConfigurationItems", (Object)(LineSeparator.value() + this.getConfigurationItems()));
        return result.toString();
    }
}

