/*
 * Decompiled with CFR 0.152.
 */
package reconf.client.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.validation.ConstraintViolation;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import reconf.client.annotations.ConfigurationRepository;
import reconf.client.annotations.DoNotUpdate;
import reconf.client.annotations.UpdateFrequency;
import reconf.client.elements.ConfigurationItemElement;
import reconf.client.elements.ConfigurationRepositoryElement;
import reconf.client.elements.DoNotUpdateElement;
import reconf.client.elements.UpdateFrequencyElement;
import reconf.client.setup.XmlConfiguration;
import reconf.infra.i18n.ClassValidatorFactory;
import reconf.infra.i18n.MessagesBundle;
import reconf.infra.log.LoggerHolder;
import reconf.infra.system.LineSeparator;
import reconf.infra.throwables.ReConfInitializationError;

public class ConfigurationRepositoryElementFactory {
    private static final MessagesBundle msg = MessagesBundle.getBundle(ConfigurationRepositoryElementFactory.class);
    private XmlConfiguration configuration;

    public ConfigurationRepositoryElementFactory(XmlConfiguration arg) {
        this.configuration = arg;
    }

    public ConfigurationRepositoryElement create(Class<?> arg) {
        ConfigurationRepositoryElement result = this.createNewRepositoryFor(arg);
        this.validate(result);
        return result;
    }

    private ConfigurationRepositoryElement createNewRepositoryFor(Class<?> arg) {
        if (!arg.isInterface()) {
            throw new ReConfInitializationError(msg.format("error.is.not.interface", new Object[]{arg.getCanonicalName()}));
        }
        if (!arg.isAnnotationPresent(ConfigurationRepository.class)) {
            return null;
        }
        ConfigurationRepositoryElement result = new ConfigurationRepositoryElement();
        this.defineReloadStrategy(arg, result);
        ConfigurationRepository ann = arg.getAnnotation(ConfigurationRepository.class);
        result.setProduct(ann.product());
        result.setComponent(ann.component());
        result.setConnectionSettings(this.configuration.getConnectionSettings());
        result.setInterfaceClass(arg);
        result.setConfigurationItems(ConfigurationItemElement.from(result));
        LoggerHolder.getLog().info(msg.format("new", new Object[]{LineSeparator.value(), result.toString()}));
        return result;
    }

    private void defineReloadStrategy(Class<?> arg, ConfigurationRepositoryElement result) {
        if (!arg.isAnnotationPresent(UpdateFrequency.class) && !arg.isAnnotationPresent(DoNotUpdate.class)) {
            LoggerHolder.getLog().warn(msg.format("reload.policy.missing", new Object[]{arg}));
            return;
        }
        if (arg.isAnnotationPresent(UpdateFrequency.class) && arg.isAnnotationPresent(DoNotUpdate.class)) {
            LoggerHolder.getLog().warn(msg.format("error.conflict.reload.policy", new Object[]{arg}));
        }
        if (arg.isAnnotationPresent(UpdateFrequency.class)) {
            if (this.configuration.getAnnotationOverride() != null) {
                UpdateFrequencyElement overrideFrequency = new UpdateFrequencyElement();
                overrideFrequency.setInterval(this.configuration.getAnnotationOverride().getInterval());
                overrideFrequency.setTimeUnit(this.configuration.getAnnotationOverride().getTimeUnit());
                result.setUpdateFrequency(overrideFrequency);
                LoggerHolder.getLog().info(msg.format("global.reload.policy.override", new Object[]{arg}));
                return;
            }
            UpdateFrequency reloadAnn = arg.getAnnotation(UpdateFrequency.class);
            UpdateFrequencyElement reloadPolicy = new UpdateFrequencyElement();
            reloadPolicy.setInterval(reloadAnn.interval());
            reloadPolicy.setTimeUnit(reloadAnn.timeUnit());
            result.setUpdateFrequency(reloadPolicy);
            return;
        }
        if (arg.isAnnotationPresent(DoNotUpdate.class)) {
            result.setDoNotUpdate(new DoNotUpdateElement());
            LoggerHolder.getLog().warn(msg.format("do.not.reload", new Object[]{arg}));
            return;
        }
    }

    private void validate(ConfigurationRepositoryElement arg) {
        if (arg == null) {
            throw new ReConfInitializationError(msg.get("error.internal"));
        }
        Set violations = ClassValidatorFactory.create(ConfigurationRepositoryElement.class).validate((Object)arg, new Class[0]);
        if (CollectionUtils.isEmpty((Collection)violations)) {
            return;
        }
        ArrayList<String> errors = new ArrayList<String>();
        int i = 1;
        for (ConstraintViolation violation : violations) {
            errors.add(i++ + " - " + violation.getMessage() + " @ " + arg.getInterfaceClass() + "." + violation.getPropertyPath());
        }
        throw new ReConfInitializationError(msg.format("error.factory", new Object[]{LineSeparator.value(), StringUtils.join(errors, (String)", ")}));
    }
}

