/*
 * Decompiled with CFR 0.152.
 */
package reconf.client.factory;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import reconf.client.constructors.ArrayConstructor;
import reconf.client.constructors.CollectionConstructor;
import reconf.client.constructors.MapConstructor;
import reconf.client.constructors.ObjectConstructor;
import reconf.client.constructors.SimpleConstructor;

public final class ObjectConstructorFactory {
    private static final ArrayConstructor array = new ArrayConstructor();
    private static final MapConstructor map = new MapConstructor();
    private static final SimpleConstructor simple = new SimpleConstructor();
    private static final CollectionConstructor collection = new CollectionConstructor();

    private ObjectConstructorFactory() {
        throw new UnsupportedOperationException();
    }

    public static ObjectConstructor get(Type type) {
        Class clazz = null;
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterized = (ParameterizedType)type;
            clazz = (Class)parameterized.getRawType();
        } else if (type instanceof Class) {
            clazz = (Class)type;
        } else {
            if (type instanceof GenericArrayType) {
                return array;
            }
            return null;
        }
        if (clazz.isArray()) {
            return array;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return collection;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return map;
        }
        return simple;
    }

    public static boolean isSimple(Type type) {
        Class clazz = null;
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterized = (ParameterizedType)type;
            clazz = (Class)parameterized.getRawType();
        } else if (type instanceof Class) {
            clazz = (Class)type;
        } else {
            if (type instanceof GenericArrayType) {
                return false;
            }
            return false;
        }
        if (clazz.isArray()) {
            return false;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return false;
        }
        return !Map.class.isAssignableFrom(clazz);
    }
}

