/*
 * Decompiled with CFR 0.152.
 */
package reconf.client.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.locks.ReentrantLock;
import reconf.client.annotations.ConfigurationItem;
import reconf.client.annotations.UpdateConfigurationRepository;
import reconf.client.config.update.ConfigurationRepositoryUpdater;
import reconf.client.elements.ConfigurationItemElement;
import reconf.client.elements.ConfigurationRepositoryElement;
import reconf.client.factory.ConfigurationRepositoryElementFactory;
import reconf.client.locator.ServiceLocator;
import reconf.client.proxy.Customization;
import reconf.client.setup.Environment;
import reconf.infra.i18n.MessagesBundle;

public class ConfigurationRepositoryFactory
implements InvocationHandler {
    private static final MessagesBundle msg = MessagesBundle.getBundle(ConfigurationRepositoryFactory.class);
    private ConfigurationRepositoryUpdater updater;
    private static ConfigurationRepositoryElementFactory factory;
    private static final ReentrantLock lock;
    private static ConcurrentMap<String, Object> cache;

    public static synchronized <T> T get(Class<T> arg) {
        ConfigurationRepositoryFactory.setUpIfNeeded();
        String key = arg.getName();
        if (cache.containsKey(key)) {
            return (T)cache.get(key);
        }
        T result = ConfigurationRepositoryFactory.newInstance(arg, Environment.getFactory().create(arg));
        cache.putIfAbsent(key, result);
        return result;
    }

    public static synchronized <T> T get(Class<T> arg, Customization customization) {
        ConfigurationRepositoryFactory.setUpIfNeeded();
        String key = arg.getName() + (customization == null ? "" : customization);
        if (cache.containsKey(key)) {
            return (T)cache.get(key);
        }
        ConfigurationRepositoryElement repo = Environment.getFactory().create(arg);
        if (customization == null) {
            customization = Customization.EMPTY;
        }
        repo.setComponent(customization.getCustomComponent(repo.getComponent()));
        for (ConfigurationItemElement item : repo.getConfigurationItems()) {
            item.setProduct(repo.getProduct());
            item.setComponent(customization.getCustomComponent(item.getComponent()));
            item.setValue(customization.getCustomItem(item.getValue()));
        }
        T result = ConfigurationRepositoryFactory.newInstance(arg, repo);
        cache.putIfAbsent(key, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void setUpIfNeeded() {
        if (factory != null) {
            return;
        }
        boolean locked = lock.tryLock();
        if (!locked) {
            return;
        }
        try {
            Environment.setUp();
            factory = Environment.getFactory();
        }
        finally {
            lock.unlock();
        }
    }

    private static synchronized <T> T newInstance(Class<T> arg, ConfigurationRepositoryElement repo) {
        ConfigurationRepositoryFactory factory = new ConfigurationRepositoryFactory();
        factory.updater = new ConfigurationRepositoryUpdater(repo, ServiceLocator.defaultImplementation);
        ScheduledExecutorService service = null;
        if (factory.updater.shouldReload()) {
            service = Executors.newScheduledThreadPool(1);
            service.scheduleAtFixedRate(factory.updater, factory.updater.getReloadInterval(), factory.updater.getReloadInterval(), factory.updater.getReloadTimeUnit());
        }
        return (T)Proxy.newProxyInstance(arg.getClassLoader(), new Class[]{arg}, (InvocationHandler)factory);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        boolean updateAnnotationPresent = method.isAnnotationPresent(UpdateConfigurationRepository.class);
        boolean configurationAnnotationPresent = method.isAnnotationPresent(ConfigurationItem.class);
        if (!configurationAnnotationPresent && !updateAnnotationPresent) {
            throw new IllegalArgumentException(msg.format("error.method", new Object[]{method}));
        }
        if (updateAnnotationPresent) {
            this.updater.syncNow(method.getAnnotation(UpdateConfigurationRepository.class).onErrorThrow());
        }
        Object configValue = null;
        if (configurationAnnotationPresent) {
            configValue = this.updater.getValueOf(method);
        }
        return configValue;
    }

    static {
        lock = new ReentrantLock();
        cache = new ConcurrentHashMap<String, Object>();
    }
}

