/*
 * Decompiled with CFR 0.152.
 */
package reconf.client.proxy;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Customization {
    public static final Customization EMPTY = new Customization();
    private String componentPrefix;
    private String componentSuffix;
    private String namePrefix;
    private String nameSuffix;

    public String getComponentPrefix() {
        return this.componentPrefix;
    }

    public void setComponentPrefix(String componentPrefix) {
        this.componentPrefix = componentPrefix;
    }

    public String getComponentSuffix() {
        return this.componentSuffix;
    }

    public void setComponentSuffix(String componentSuffix) {
        this.componentSuffix = componentSuffix;
    }

    public String getComponentItemPrefix() {
        return this.namePrefix;
    }

    public void setComponentItemPrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    public String getComponentItemSuffix() {
        return this.nameSuffix;
    }

    public void setComponentItemSuffix(String nameSuffix) {
        this.nameSuffix = nameSuffix;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    public boolean isValid() {
        return StringUtils.isNotBlank((String)this.componentPrefix) || StringUtils.isNotBlank((String)this.componentSuffix) || StringUtils.isNotBlank((String)this.namePrefix) || StringUtils.isNotBlank((String)this.nameSuffix);
    }

    public String toString() {
        return "componentPrefix [" + StringUtils.defaultString((String)this.componentPrefix) + "] " + "componentSuffix [" + StringUtils.defaultString((String)this.componentSuffix) + "] " + "keyPrefix [" + StringUtils.defaultString((String)this.namePrefix) + "] " + "keySuffix [" + StringUtils.defaultString((String)this.nameSuffix) + "]";
    }

    public String getCustomComponent(String originalComponent) {
        if (StringUtils.isBlank((String)originalComponent) || StringUtils.isBlank((String)this.getComponentPrefix()) && StringUtils.isBlank((String)this.getComponentSuffix())) {
            return originalComponent;
        }
        StringBuilder builder = new StringBuilder();
        if (StringUtils.isNotBlank((String)this.getComponentPrefix())) {
            builder.append(this.getComponentPrefix());
        }
        builder.append(originalComponent);
        if (StringUtils.isNotBlank((String)this.getComponentSuffix())) {
            builder.append(this.getComponentSuffix());
        }
        return builder.toString();
    }

    public String getCustomItem(String originalKey) {
        if (StringUtils.isBlank((String)originalKey) || StringUtils.isBlank((String)this.getComponentItemPrefix()) && StringUtils.isBlank((String)this.getComponentItemSuffix())) {
            return originalKey;
        }
        StringBuilder builder = new StringBuilder();
        if (StringUtils.isNotBlank((String)this.getComponentItemPrefix())) {
            builder.append(this.getComponentItemPrefix());
        }
        builder.append(originalKey);
        if (StringUtils.isNotBlank((String)this.getComponentItemSuffix())) {
            builder.append(this.getComponentItemSuffix());
        }
        return builder.toString();
    }
}

