/*
 * Decompiled with CFR 0.152.
 */
package reconf.client.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import reconf.client.adapters.ConfigurationAdapter;
import reconf.client.config.source.ConfigurationSourceHolder;
import reconf.client.config.source.DatabaseConfigurationSource;
import reconf.client.config.source.RemoteConfigurationSource;
import reconf.client.elements.ConfigurationItemElement;
import reconf.client.elements.ConfigurationRepositoryElement;
import reconf.client.elements.FullPropertyElement;
import reconf.client.locator.ServiceLocator;
import reconf.client.setup.ConnectionSettings;
import reconf.infra.http.ServerStub;
import reconf.infra.i18n.MessagesBundle;

public class MethodConfiguration {
    private static final MessagesBundle msg = MessagesBundle.getBundle(MethodConfiguration.class);
    private final ConfigurationRepositoryElement cfgRepository;
    private final ConfigurationItemElement remoteItem;
    private final ServerStub stub;
    private final ServiceLocator locator;

    public MethodConfiguration(ConfigurationRepositoryElement cfgRepository, ConfigurationItemElement itemConfiguration, ServiceLocator locator) {
        this.cfgRepository = cfgRepository;
        this.remoteItem = itemConfiguration;
        this.locator = locator;
        this.stub = this.createStub();
    }

    public ConfigurationSourceHolder getConfigurationSourceHolder() {
        try {
            ConfigurationAdapter adapter = this.getRemoteAdapter();
            ConfigurationSourceHolder holder = new ConfigurationSourceHolder(new RemoteConfigurationSource(this.remoteItem.getValue(), this.stub, adapter), new DatabaseConfigurationSource(FullPropertyElement.from(this.stub.getProduct(), this.stub.getComponent(), this.remoteItem.getValue()), this.getMethod(), adapter, this.locator));
            return holder;
        }
        catch (Throwable t) {
            throw new IllegalStateException(msg.get("error.source"), t);
        }
    }

    private ConfigurationAdapter getRemoteAdapter() {
        if (null == this.remoteItem || this.remoteItem.getAdapter() == null) {
            return null;
        }
        try {
            Constructor<? extends ConfigurationAdapter> constructor = this.remoteItem.getAdapter().getConstructor(ArrayUtils.EMPTY_CLASS_ARRAY);
            return constructor.newInstance(ArrayUtils.EMPTY_OBJECT_ARRAY);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(msg.get("error.adapter"), t);
        }
    }

    private ServerStub createStub() {
        ConnectionSettings settings = this.cfgRepository.getConnectionSettings();
        ServerStub stub = this.locator.serverStubFactory().serverStub(settings.getUrl(), settings.getTimeout(), settings.getTimeUnit(), settings.getMaxRetry());
        stub.setComponent(StringUtils.isNotBlank((String)this.remoteItem.getComponent()) ? this.remoteItem.getComponent() : this.cfgRepository.getComponent());
        stub.setProduct(StringUtils.isNotBlank((String)this.remoteItem.getProduct()) ? this.remoteItem.getProduct() : this.cfgRepository.getProduct());
        return stub;
    }

    public int getReloadInterval() {
        switch (this.getReloadStrategy()) {
            case ATOMIC: {
                return this.cfgRepository.getUpdateFrequency().getInterval();
            }
            case INDEPENDENT: {
                return this.remoteItem.getUpdateFrequency().getInterval();
            }
            case NONE: {
                return 0;
            }
        }
        throw new IllegalStateException(msg.get("error.internal"));
    }

    public TimeUnit getReloadTimeUnit() {
        switch (this.getReloadStrategy()) {
            case ATOMIC: {
                return this.cfgRepository.getUpdateFrequency().getTimeUnit();
            }
            case INDEPENDENT: {
                return this.remoteItem.getUpdateFrequency().getTimeUnit();
            }
            case NONE: {
                return TimeUnit.DAYS;
            }
        }
        throw new IllegalStateException(msg.get("error.internal"));
    }

    public ReloadStrategy getReloadStrategy() {
        if (this.remoteItem.getDoNotUpdate() != null) {
            return ReloadStrategy.NONE;
        }
        if (this.remoteItem.getUpdateFrequency() != null) {
            return ReloadStrategy.INDEPENDENT;
        }
        if (this.cfgRepository.getDoNotUpdate() != null) {
            return ReloadStrategy.NONE;
        }
        return null != this.cfgRepository.getUpdateFrequency() ? ReloadStrategy.ATOMIC : ReloadStrategy.NONE;
    }

    public Method getMethod() {
        return this.remoteItem.getMethod();
    }

    public ServerStub getServerStub() {
        return this.stub;
    }

    public static enum ReloadStrategy {
        NONE,
        ATOMIC,
        INDEPENDENT;

    }
}

